/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.encryption;

import java.util.ArrayList;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.AbstractEncryptedKeyResolver;
import org.opensaml.xml.encryption.EncryptedData;
import org.opensaml.xml.encryption.EncryptedKey;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.KeyInfoReference;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleKeyInfoReferenceEncryptedKeyResolver
extends AbstractEncryptedKeyResolver {
    private final Logger log = LoggerFactory.getLogger(SimpleKeyInfoReferenceEncryptedKeyResolver.class);
    private int depthLimit = 5;

    SimpleKeyInfoReferenceEncryptedKeyResolver() {
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    public void setDepthLimit(int limit) {
        this.depthLimit = Math.max(1, limit);
    }

    @Override
    public Iterable<EncryptedKey> resolve(EncryptedData encryptedData) {
        return this.resolveKeyInfo(encryptedData.getKeyInfo(), this.depthLimit);
    }

    protected Iterable<EncryptedKey> resolveKeyInfo(KeyInfo keyInfo, int limit) {
        ArrayList<EncryptedKey> resolvedEncKeys = new ArrayList<EncryptedKey>();
        if (keyInfo == null) {
            return resolvedEncKeys;
        }
        if (limit < this.depthLimit) {
            for (EncryptedKey encKey : keyInfo.getEncryptedKeys()) {
                if (!this.matchRecipient(encKey.getRecipient())) continue;
                resolvedEncKeys.add(encKey);
            }
        }
        if (limit == 0) {
            this.log.info("Reached depth limit for KeyInfoReferences");
        } else {
            for (XMLObject xo : keyInfo.getXMLObjects(KeyInfoReference.DEFAULT_ELEMENT_NAME)) {
                for (EncryptedKey encKey : this.resolveKeyInfo(this.dereferenceURI((KeyInfoReference)xo), limit - 1)) {
                    resolvedEncKeys.add(encKey);
                }
            }
        }
        return resolvedEncKeys;
    }

    protected KeyInfo dereferenceURI(KeyInfoReference ref) {
        String uri = ref.getURI();
        if (DatatypeHelper.isEmpty(uri) || !uri.startsWith("#")) {
            this.log.warn("EncryptedKey KeyInfoReference did not contain a same-document URI reference, cannot process");
            return null;
        }
        XMLObject target = ref.resolveIDFromRoot(uri.substring(1));
        if (target == null) {
            this.log.warn("EncryptedKey KeyInfoReference URI could not be dereferenced");
            return null;
        }
        if (!(target instanceof KeyInfo)) {
            this.log.warn("The product of dereferencing the EncryptedKey KeyInfoReference was not a KeyInfo");
            return null;
        }
        return (KeyInfo)target;
    }
}

