/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wsaddressing.messaging.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.SOAPMessagingBaseTestCase;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.wsaddressing.MessageID;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.opensaml.soap.wsaddressing.messaging.impl.AddMessageIDHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddMessageIDHandlerTest
extends SOAPMessagingBaseTestCase {
    private AddMessageIDHandler handler;

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException {
        this.handler = new AddMessageIDHandler();
    }

    @Test
    public void testDefaultInternalUUID() throws ComponentInitializationException, MessageHandlerException {
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)MessageID.ELEMENT_NAME).isEmpty());
        MessageID messageID = (MessageID)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)MessageID.ELEMENT_NAME).get(0);
        Assert.assertTrue((boolean)messageID.getValue().startsWith("urn:uuid:"));
    }

    @Test
    public void testStrategy() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setIdentifierGenerationStrategy(new IdentifierGenerationStrategy(){

            @Nonnull
            public String generateIdentifier(boolean xmlSafe) {
                if (xmlSafe) {
                    return "urn:test:abc123:xmlsafe";
                }
                return "urn:test:abc123";
            }

            @Nonnull
            public String generateIdentifier() {
                return this.generateIdentifier(true);
            }
        });
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)MessageID.ELEMENT_NAME).isEmpty());
        MessageID messageID = (MessageID)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)MessageID.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)messageID.getValue(), (String)"urn:test:abc123");
    }

    @Test
    public void testContext() throws ComponentInitializationException, MessageHandlerException {
        ((WSAddressingContext)this.getMessageContext().getSubcontext(WSAddressingContext.class, true)).setMessageIDURI("urn:test:abc123");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)MessageID.ELEMENT_NAME).isEmpty());
        MessageID messageID = (MessageID)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)MessageID.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)messageID.getValue(), (String)"urn:test:abc123");
    }

    @Test
    public void testContextOverride() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setIdentifierGenerationStrategy(new IdentifierGenerationStrategy(){

            @Nonnull
            public String generateIdentifier(boolean xmlSafe) {
                if (xmlSafe) {
                    return "urn:test:abc123:xmlsafe";
                }
                return "urn:test:abc123";
            }

            @Nonnull
            public String generateIdentifier() {
                return this.generateIdentifier(true);
            }
        });
        ((WSAddressingContext)this.getMessageContext().getSubcontext(WSAddressingContext.class, true)).setMessageIDURI("urn:test:def456");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)MessageID.ELEMENT_NAME).isEmpty());
        MessageID messageID = (MessageID)SOAPMessagingSupport.getOutboundHeaderBlock(this.getMessageContext(), (QName)MessageID.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)messageID.getValue(), (String)"urn:test:def456");
    }
}

