/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.profile.impl.AddSOAPFault;
import org.opensaml.soap.util.SOAPSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddSOAPFaultTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext<Object, Fault> prc;
    private AddSOAPFault action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new AddSOAPFault();
    }

    @Test
    public void testMinimal() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getMessage());
        Fault fault = ((SOAP11Context)this.prc.getOutboundMessageContext().getSubcontext(SOAP11Context.class, true)).getFault();
        Assert.assertNotNull((Object)fault);
        Assert.assertNotNull((Object)fault.getCode());
        Assert.assertEquals((Object)fault.getCode().getValue(), (Object)FaultCode.SERVER);
        Assert.assertNull((Object)fault.getMessage());
    }

    @Test
    public void testFixedMessage() throws ComponentInitializationException {
        this.action.setFaultString("Foo");
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getMessage());
        Fault fault = ((SOAP11Context)this.prc.getOutboundMessageContext().getSubcontext(SOAP11Context.class, true)).getFault();
        Assert.assertNotNull((Object)fault);
        Assert.assertNotNull((Object)fault.getCode());
        Assert.assertEquals((Object)fault.getCode().getValue(), (Object)FaultCode.SERVER);
        Assert.assertEquals((String)fault.getMessage().getValue(), (String)"Foo");
    }

    @Test
    public void testCodeAndStringViaLookupWithDetailedErrors() throws ComponentInitializationException {
        this.action.setFaultCodeLookupStrategy((Function)new Function<ProfileRequestContext, QName>(){

            @Nullable
            public QName apply(@Nullable ProfileRequestContext input) {
                return FaultCode.CLIENT;
            }
        });
        this.action.setFaultStringLookupStrategy((Function)new Function<ProfileRequestContext, String>(){

            @Nullable
            public String apply(@Nullable ProfileRequestContext input) {
                return "TheClientError";
            }
        });
        this.action.setDetailedErrorsCondition(Predicates.alwaysTrue());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getMessage());
        Fault fault = ((SOAP11Context)this.prc.getOutboundMessageContext().getSubcontext(SOAP11Context.class, true)).getFault();
        Assert.assertNotNull((Object)fault);
        Assert.assertNotNull((Object)fault.getCode());
        Assert.assertEquals((Object)fault.getCode().getValue(), (Object)FaultCode.CLIENT);
        Assert.assertNotNull((Object)fault.getMessage());
        Assert.assertEquals((String)fault.getMessage().getValue(), (String)"TheClientError");
        Assert.assertNull((Object)fault.getActor());
        Assert.assertNull((Object)fault.getDetail());
    }

    @Test
    public void testCodeAndStringViaLookupWithoutDetailedErrors() throws ComponentInitializationException {
        this.action.setFaultCodeLookupStrategy((Function)new Function<ProfileRequestContext, QName>(){

            @Nullable
            public QName apply(@Nullable ProfileRequestContext input) {
                return FaultCode.CLIENT;
            }
        });
        this.action.setFaultStringLookupStrategy((Function)new Function<ProfileRequestContext, String>(){

            @Nullable
            public String apply(@Nullable ProfileRequestContext input) {
                return "TheClientError";
            }
        });
        this.action.setDetailedErrorsCondition(Predicates.alwaysFalse());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getMessage());
        Fault fault = ((SOAP11Context)this.prc.getOutboundMessageContext().getSubcontext(SOAP11Context.class, true)).getFault();
        Assert.assertNotNull((Object)fault);
        Assert.assertNotNull((Object)fault.getCode());
        Assert.assertEquals((Object)fault.getCode().getValue(), (Object)FaultCode.CLIENT);
        Assert.assertNull((Object)fault.getMessage());
        Assert.assertNull((Object)fault.getActor());
        Assert.assertNull((Object)fault.getDetail());
    }

    @Test
    public void testContextFaultWithDetailedErrors() throws ComponentInitializationException {
        final Fault contextFault = SOAPSupport.buildSOAP11Fault((QName)FaultCode.CLIENT, (String)"TheClientError", (String)"TheFaultActor", Collections.singletonList(XMLObjectSupport.buildXMLObject((QName)SimpleXMLObject.ELEMENT_NAME)), null);
        this.action.setContextFaultStrategy((Function)new Function<ProfileRequestContext, Fault>(){

            @Nullable
            public Fault apply(@Nullable ProfileRequestContext input) {
                return contextFault;
            }
        });
        this.action.setDetailedErrorsCondition(Predicates.alwaysTrue());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getMessage());
        Fault fault = ((SOAP11Context)this.prc.getOutboundMessageContext().getSubcontext(SOAP11Context.class, true)).getFault();
        Assert.assertNotNull((Object)fault);
        Assert.assertNotNull((Object)fault.getCode());
        Assert.assertEquals((Object)fault.getCode().getValue(), (Object)FaultCode.CLIENT);
        Assert.assertEquals((String)fault.getMessage().getValue(), (String)"TheClientError");
        Assert.assertEquals((String)fault.getActor().getValue(), (String)"TheFaultActor");
        Assert.assertNotNull((Object)fault.getDetail());
        Assert.assertEquals((int)fault.getDetail().getUnknownXMLObjects().size(), (int)1);
    }

    @Test
    public void testContextFaultWithoutDetailedErrors() throws ComponentInitializationException {
        final Fault contextFault = SOAPSupport.buildSOAP11Fault((QName)FaultCode.CLIENT, (String)"TheClientError", (String)"TheFaultActor", Collections.singletonList(XMLObjectSupport.buildXMLObject((QName)SimpleXMLObject.ELEMENT_NAME)), null);
        this.action.setContextFaultStrategy((Function)new Function<ProfileRequestContext, Fault>(){

            @Nullable
            public Fault apply(@Nullable ProfileRequestContext input) {
                return contextFault;
            }
        });
        this.action.setDetailedErrorsCondition(Predicates.alwaysFalse());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getMessage());
        Fault fault = ((SOAP11Context)this.prc.getOutboundMessageContext().getSubcontext(SOAP11Context.class, true)).getFault();
        Assert.assertNotNull((Object)fault);
        Assert.assertNotNull((Object)fault.getCode());
        Assert.assertEquals((Object)fault.getCode().getValue(), (Object)FaultCode.CLIENT);
        Assert.assertNull((Object)fault.getMessage());
        Assert.assertNull((Object)fault.getActor());
        Assert.assertNull((Object)fault.getDetail());
    }

    @Test
    public void testDefaultContextFaultStrategyFromOutbound() throws ComponentInitializationException {
        Fault contextFault = SOAPSupport.buildSOAP11Fault((QName)FaultCode.CLIENT, (String)"TheClientError", (String)"TheFaultActor", Collections.singletonList(XMLObjectSupport.buildXMLObject((QName)SimpleXMLObject.ELEMENT_NAME)), null);
        ((SOAP11Context)this.prc.getOutboundMessageContext().getSubcontext(SOAP11Context.class, true)).setFault(contextFault);
        this.action.setDetailedErrorsCondition(Predicates.alwaysFalse());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getMessage());
        Fault fault = ((SOAP11Context)this.prc.getOutboundMessageContext().getSubcontext(SOAP11Context.class, true)).getFault();
        Assert.assertNotNull((Object)fault);
        Assert.assertNotNull((Object)fault.getCode());
        Assert.assertEquals((Object)fault.getCode().getValue(), (Object)FaultCode.CLIENT);
        Assert.assertNull((Object)fault.getMessage());
        Assert.assertNull((Object)fault.getActor());
        Assert.assertNull((Object)fault.getDetail());
    }

    @Test
    public void testDefaultContextFaultStrategyFromInbound() throws ComponentInitializationException {
        Fault contextFault = SOAPSupport.buildSOAP11Fault((QName)FaultCode.CLIENT, (String)"TheClientError", (String)"TheFaultActor", Collections.singletonList(XMLObjectSupport.buildXMLObject((QName)SimpleXMLObject.ELEMENT_NAME)), null);
        ((SOAP11Context)this.prc.getInboundMessageContext().getSubcontext(SOAP11Context.class, true)).setFault(contextFault);
        this.action.setDetailedErrorsCondition(Predicates.alwaysFalse());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assert.assertNull((Object)this.prc.getOutboundMessageContext().getMessage());
        Fault fault = ((SOAP11Context)this.prc.getOutboundMessageContext().getSubcontext(SOAP11Context.class, true)).getFault();
        Assert.assertNotNull((Object)fault);
        Assert.assertNotNull((Object)fault.getCode());
        Assert.assertEquals((Object)fault.getCode().getValue(), (Object)FaultCode.CLIENT);
        Assert.assertNull((Object)fault.getMessage());
        Assert.assertNull((Object)fault.getActor());
        Assert.assertNull((Object)fault.getDetail());
    }
}

