/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.security.impl;

import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAMLSignatureProfileValidatorTest
extends XMLObjectBaseTestCase {
    private SAMLSignatureProfileValidator validator;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.validator = new SAMLSignatureProfileValidator();
    }

    @Test
    public void testValid() {
        Signature sig = this.getSignature("/org/opensaml/saml/security/Signed-AuthnRequest-Valid.xml");
        this.assertValidationPass("Valid signature", sig);
    }

    @Test
    public void testInvalidNoXMLSignature() {
        Signature sig = this.getSignature("/org/opensaml/saml/security/Signed-AuthnRequest-Valid.xml");
        ((SignatureImpl)sig).setXMLSignature(null);
        this.assertValidationFail("Invalid signature - no XMLSignature", sig);
    }

    @Test
    public void testInvalidTooManyReferences() {
        Signature sig = this.getSignature("/org/opensaml/saml/security/Signed-AuthnRequest-TooManyReferences.xml");
        this.assertValidationFail("Invalid signature - too many References", sig);
    }

    @Test
    public void testInvalidNonLocalURI() {
        Signature sig = this.getSignature("/org/opensaml/saml/security/Signed-AuthnRequest-NonLocalURI.xml");
        this.assertValidationFail("Invalid signature - non-local Reference URI", sig);
    }

    @Test
    public void testInvalidMissingID() {
        Signature sig = this.getSignature("/org/opensaml/saml/security/Signed-AuthnRequest-MissingID.xml");
        this.assertValidationFail("Invalid signature - missing ID on parent object", sig);
    }

    @Test
    public void testInvalidBadURIValue() {
        Signature sig = this.getSignature("/org/opensaml/saml/security/Signed-AuthnRequest-BadURIValue.xml");
        this.assertValidationFail("Invalid signature - bad URI value", sig);
    }

    @Test
    public void testInvalidTooManyTransforms() {
        Signature sig = this.getSignature("/org/opensaml/saml/security/Signed-AuthnRequest-TooManyTransforms.xml");
        this.assertValidationFail("Invalid signature - too many Transforms", sig);
    }

    @Test
    public void testInvalidBadTransform() {
        Signature sig = this.getSignature("/org/opensaml/saml/security/Signed-AuthnRequest-BadTransform.xml");
        this.assertValidationFail("Invalid signature - bad Transform", sig);
    }

    @Test
    public void testInvalidMissingEnvelopedTransform() {
        Signature sig = this.getSignature("/org/opensaml/saml/security/Signed-AuthnRequest-MissingEnvelopedTransform.xml");
        this.assertValidationFail("Invalid signature - missing Enveloped Transform", sig);
    }

    @Test
    public void testInvalidDuplicateIDs() {
        Signature sig = this.getSignature("/org/opensaml/saml/security/Signed-AuthnRequest-DuplicateIDs.xml");
        this.assertValidationFail("Invalid signature - duplicate IDs", sig);
    }

    protected Signature getSignature(String filename) {
        SignableSAMLObject signableObj = (SignableSAMLObject)this.unmarshallElement(filename);
        return signableObj.getSignature();
    }

    protected void assertValidationPass(String message, Signature validateTarget) {
        try {
            this.validator.validate(validateTarget);
        }
        catch (SignatureException e) {
            Assert.fail((String)(message + " : Expected success, but validation failure raised ValidationException: " + e.getMessage()));
        }
    }

    protected void assertValidationFail(String message, Signature validateTarget) {
        try {
            this.validator.validate(validateTarget);
            Assert.fail((String)(message + " : Validation success, expected failure to raise ValidationException"));
        }
        catch (SignatureException signatureException) {
            // empty catch block
        }
    }
}

