/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.opensaml.saml.saml2.profile.impl.AddSubjectConfirmationToSubjects;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddSubjectConfirmationToSubjectsTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext<AuthnRequest, Response> prc;
    private AddSubjectConfirmationToSubjects action;

    @BeforeMethod
    public void setUp() {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new AddSubjectConfirmationToSubjects();
        this.action.setHttpServletRequest((HttpServletRequest)new MockHttpServletRequest());
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testBadConfig() throws ComponentInitializationException {
        this.action.initialize();
    }

    @Test
    public void testNoMessage() throws ComponentInitializationException {
        this.action.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent(this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoAssertions() throws ComponentInitializationException {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildResponse());
        this.action.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assert.assertTrue((boolean)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().isEmpty());
    }

    @Test
    void testSuccess() throws ComponentInitializationException {
        this.addAssertions();
        this.action.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Subject subject = assertion.getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertEquals((int)subject.getSubjectConfirmations().size(), (int)1);
        Assert.assertEquals((String)((SubjectConfirmation)subject.getSubjectConfirmations().get(0)).getMethod(), (String)"urn:oasis:names:tc:SAML:2.0:cm:bearer");
        assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(1);
        subject = assertion.getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertEquals((int)subject.getSubjectConfirmations().size(), (int)1);
        Assert.assertEquals((String)((SubjectConfirmation)subject.getSubjectConfirmations().get(0)).getMethod(), (String)"urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SubjectConfirmationData data = ((SubjectConfirmation)subject.getSubjectConfirmations().get(0)).getSubjectConfirmationData();
        Assert.assertNotNull((Object)data);
        Assert.assertNull((Object)data.getRecipient());
        Assert.assertNotNull((Object)data.getNotOnOrAfter());
        Assert.assertEquals((String)data.getAddress(), (String)"127.0.0.1");
        Assert.assertEquals((String)data.getInResponseTo(), (String)((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).getID());
    }

    private void addAssertions() {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.prc.getOutboundMessageContext().setMessage((Object)response);
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        this.prc.getInboundMessageContext().getSubcontext(SAMLMessageInfoContext.class, true);
        response.setInResponseTo(((AuthnRequest)this.prc.getInboundMessageContext().getMessage()).getID());
    }
}

