/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.util.Arrays;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.opensaml.saml.saml2.profile.impl.AddStatusToResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddStatusToResponseTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext<Object, Response> prc;
    private AddStatusToResponse action;

    @BeforeMethod
    public void setUp() {
        this.prc = new RequestContextBuilder().setOutboundMessage((Object)SAML2ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        this.action = new AddStatusToResponse();
    }

    @Test
    public void testMinimal() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Status status = response.getStatus();
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull((Object)status.getStatusCode());
        Assert.assertEquals((String)status.getStatusCode().getValue(), (String)"urn:oasis:names:tc:SAML:2.0:status:Responder");
        Assert.assertNull((Object)status.getStatusCode().getStatusCode());
        Assert.assertNull((Object)status.getStatusMessage());
    }

    @Test
    public void testMultiStatus() throws ComponentInitializationException {
        this.action.setStatusCodes(Arrays.asList("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestVersionDeprecated"));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Status status = response.getStatus();
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull((Object)status.getStatusCode());
        Assert.assertEquals((String)status.getStatusCode().getValue(), (String)"urn:oasis:names:tc:SAML:2.0:status:Requester");
        Assert.assertNotNull((Object)status.getStatusCode().getStatusCode());
        Assert.assertEquals((String)status.getStatusCode().getStatusCode().getValue(), (String)"urn:oasis:names:tc:SAML:2.0:status:RequestVersionDeprecated");
        Assert.assertNull((Object)status.getStatusCode().getStatusCode().getStatusCode());
        Assert.assertNull((Object)status.getStatusMessage());
    }

    @Test
    public void testFixedMessage() throws ComponentInitializationException {
        this.action.setStatusMessage("Foo");
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Response response = (Response)this.prc.getOutboundMessageContext().getMessage();
        Status status = response.getStatus();
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((String)status.getStatusMessage().getMessage(), (String)"Foo");
    }
}

