/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import com.google.common.base.Function;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.opensaml.saml.saml2.profile.impl.AddStatusResponseShell;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddStatusResponseShellTest
extends OpenSAMLInitBaseTestCase {
    private String issuer;
    private AddStatusResponseShell action;

    @BeforeMethod
    public void setUp() {
        this.issuer = null;
        this.action = new AddStatusResponseShell();
        this.action.setIssuerLookupStrategy((Function)new Function<ProfileRequestContext, String>(){

            public String apply(ProfileRequestContext input) {
                return AddStatusResponseShellTest.this.issuer;
            }
        });
    }

    @Test
    public void testAddResponse() throws ComponentInitializationException {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action.setMessageType(Response.DEFAULT_ELEMENT_NAME);
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        MessageContext outMsgCtx = prc.getOutboundMessageContext();
        Response response = (Response)outMsgCtx.getMessage();
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getID());
        Assert.assertNotNull((Object)response.getIssueInstant());
        Assert.assertEquals((Object)response.getVersion(), (Object)SAMLVersion.VERSION_20);
        Assert.assertNull((Object)response.getIssuer());
        Status status = response.getStatus();
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull((Object)status.getStatusCode());
        Assert.assertEquals((String)status.getStatusCode().getValue(), (String)"urn:oasis:names:tc:SAML:2.0:status:Success");
    }

    @Test
    public void testAddResponseWithIssuer() throws ComponentInitializationException {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        this.issuer = "foo";
        this.action.setMessageType(Response.DEFAULT_ELEMENT_NAME);
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        MessageContext outMsgCtx = prc.getOutboundMessageContext();
        Response response = (Response)outMsgCtx.getMessage();
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getIssuer());
        Assert.assertEquals((String)response.getIssuer().getValue(), (String)"foo");
    }

    @Test
    public void testAddResponseWhenResponseAlreadyExist() throws ComponentInitializationException {
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)SAML2ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        this.action.setMessageType(Response.DEFAULT_ELEMENT_NAME);
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testAddArtifactResponse() throws ComponentInitializationException {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action.setMessageType(ArtifactResponse.DEFAULT_ELEMENT_NAME);
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        MessageContext outMsgCtx = prc.getOutboundMessageContext();
        ArtifactResponse response = (ArtifactResponse)outMsgCtx.getMessage();
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getID());
        Assert.assertNotNull((Object)response.getIssueInstant());
        Assert.assertEquals((Object)response.getVersion(), (Object)SAMLVersion.VERSION_20);
        Assert.assertNull((Object)response.getIssuer());
        Status status = response.getStatus();
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull((Object)status.getStatusCode());
        Assert.assertEquals((String)status.getStatusCode().getValue(), (String)"urn:oasis:names:tc:SAML:2.0:status:Success");
    }

    @Test
    public void testAddLogoutResponse() throws ComponentInitializationException {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action.setMessageType(LogoutResponse.DEFAULT_ELEMENT_NAME);
        this.action.initialize();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        MessageContext outMsgCtx = prc.getOutboundMessageContext();
        LogoutResponse response = (LogoutResponse)outMsgCtx.getMessage();
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getID());
        Assert.assertNotNull((Object)response.getIssueInstant());
        Assert.assertEquals((Object)response.getVersion(), (Object)SAMLVersion.VERSION_20);
        Assert.assertNull((Object)response.getIssuer());
        Status status = response.getStatus();
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull((Object)status.getStatusCode());
        Assert.assertEquals((String)status.getStatusCode().getValue(), (String)"urn:oasis:names:tc:SAML:2.0:status:Success");
    }
}

