/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.impl.XSAnyBuilder;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml.saml2.metadata.impl.RequestedAttributeBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RequestedAttributeTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedName;
    protected String expectedNameFormat;
    protected String expectedFriendlyName;
    protected XSBooleanValue expectedIsRequired;
    protected String expectedAttributeValue0;
    protected String expectedAttributeValue1;

    public RequestedAttributeTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/RequestedAttribute.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/RequestedAttributeOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/RequestedAttributeChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedName = "attribName";
        this.expectedNameFormat = "urn:string";
        this.expectedFriendlyName = "Attribute Name";
        this.expectedIsRequired = new XSBooleanValue(Boolean.TRUE, false);
        this.expectedAttributeValue0 = "SomeAttributeValue0";
        this.expectedAttributeValue1 = "SomeAttributeValue1";
    }

    @Test
    public void testSingleElementUnmarshall() {
        RequestedAttribute attribute = (RequestedAttribute)this.unmarshallElement(this.singleElementFile);
        String name = attribute.getName();
        Assert.assertEquals((String)name, (String)this.expectedName, (String)("Name was " + name + ", expected " + this.expectedName));
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        RequestedAttribute requestedAttribute = (RequestedAttribute)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        String name = requestedAttribute.getName();
        Assert.assertEquals((String)name, (String)this.expectedName, (String)("Name was " + name + ", expected " + this.expectedName));
        String nameFormat = requestedAttribute.getNameFormat();
        Assert.assertEquals((String)nameFormat, (String)this.expectedNameFormat, (String)("NameFormat was " + nameFormat + ", expected " + this.expectedNameFormat));
        String friendlyName = requestedAttribute.getFriendlyName();
        Assert.assertEquals((String)friendlyName, (String)this.expectedFriendlyName, (String)("FriendlyName was " + friendlyName + ", expected " + this.expectedFriendlyName));
        boolean isRequired = requestedAttribute.isRequired();
        Assert.assertEquals((Object)requestedAttribute.isRequiredXSBoolean(), (Object)this.expectedIsRequired, (String)("Is Required was " + isRequired + ", expected " + this.expectedIsRequired));
    }

    @Test
    public void testChildElementsUnmarshall() {
        RequestedAttribute attribute = (RequestedAttribute)this.unmarshallElement(this.childElementsFile);
        String name = attribute.getName();
        Assert.assertEquals((String)name, (String)this.expectedName, (String)("Name was " + name + ", expected " + this.expectedName));
        Assert.assertEquals((int)attribute.getAttributeValues().size(), (int)2);
        Assert.assertTrue((boolean)(attribute.getAttributeValues().get(0) instanceof XSAny));
        XSAny value0 = (XSAny)attribute.getAttributeValues().get(0);
        Assert.assertEquals((String)value0.getTextContent(), (String)this.expectedAttributeValue0);
        Assert.assertTrue((boolean)(attribute.getAttributeValues().get(1) instanceof XSAny));
        XSAny value1 = (XSAny)attribute.getAttributeValues().get(1);
        Assert.assertEquals((String)value1.getTextContent(), (String)this.expectedAttributeValue1);
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "RequestedAttribute", "md");
        RequestedAttribute requestedAttribute = (RequestedAttribute)this.buildXMLObject(qname);
        requestedAttribute.setName(this.expectedName);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)requestedAttribute);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        RequestedAttribute requestedAttribute = new RequestedAttributeBuilder().buildObject();
        requestedAttribute.setName(this.expectedName);
        requestedAttribute.setNameFormat(this.expectedNameFormat);
        requestedAttribute.setFriendlyName(this.expectedFriendlyName);
        requestedAttribute.setIsRequired(this.expectedIsRequired);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)requestedAttribute);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "RequestedAttribute", "md");
        RequestedAttribute requestedAttribute = (RequestedAttribute)this.buildXMLObject(qname);
        requestedAttribute.setName(this.expectedName);
        XSAnyBuilder valueBuilder = (XSAnyBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(XSAny.TYPE_NAME);
        XSAny val0 = (XSAny)valueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        val0.setTextContent(this.expectedAttributeValue0);
        requestedAttribute.getAttributeValues().add(val0);
        XSAny val1 = (XSAny)valueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        val1.setTextContent(this.expectedAttributeValue1);
        requestedAttribute.getAttributeValues().add(val1);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)requestedAttribute);
    }

    @Test
    public void testXSBooleanAttributes() {
        RequestedAttribute attrib = (RequestedAttribute)this.buildXMLObject(RequestedAttribute.DEFAULT_ELEMENT_NAME);
        attrib.setIsRequired(Boolean.TRUE);
        Assert.assertEquals((Object)attrib.isRequired(), (Object)Boolean.TRUE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)attrib.isRequiredXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)attrib.isRequiredXSBoolean(), (Object)new XSBooleanValue(Boolean.TRUE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)attrib.isRequiredXSBoolean().toString(), (String)"true", (String)"XSBooleanValue string was unexpected value");
        attrib.setIsRequired(Boolean.FALSE);
        Assert.assertEquals((Object)attrib.isRequired(), (Object)Boolean.FALSE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)attrib.isRequiredXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)attrib.isRequiredXSBoolean(), (Object)new XSBooleanValue(Boolean.FALSE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)attrib.isRequiredXSBoolean().toString(), (String)"false", (String)"XSBooleanValue string was unexpected value");
        attrib.setIsRequired((Boolean)null);
        Assert.assertEquals((Object)attrib.isRequired(), (Object)Boolean.FALSE, (String)"Unexpected default value for boolean attribute found");
        Assert.assertNull((Object)attrib.isRequiredXSBoolean(), (String)"XSBooleanValue was not null");
    }
}

