/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.metadata.AdditionalMetadataLocation;
import org.opensaml.saml.saml2.metadata.impl.AdditionalMetadataLocationBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AdditionalMetadataLocationTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedNamespace;
    protected String expectedContent;

    public AdditionalMetadataLocationTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/AdditionalMetadataLocation.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedNamespace = "http://example.org/xmlns";
        this.expectedContent = "http://example.org";
    }

    @Test
    public void testSingleElementUnmarshall() {
        AdditionalMetadataLocation locationObj = (AdditionalMetadataLocation)this.unmarshallElement(this.singleElementFile);
        String location = locationObj.getLocationURI();
        Assert.assertEquals((String)location, (String)this.expectedContent, (String)("Location URI was " + location + ", expected " + this.expectedContent));
        String namespace = locationObj.getNamespaceURI();
        Assert.assertEquals((String)namespace, (String)this.expectedNamespace, (String)("Namepsace URI was " + namespace + ", expected " + this.expectedNamespace));
    }

    @Test
    public void testSingleElementMarshall() {
        AdditionalMetadataLocation location = new AdditionalMetadataLocationBuilder().buildObject();
        location.setLocationURI(this.expectedContent);
        location.setNamespaceURI(this.expectedNamespace);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)location);
    }
}

