/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.encryption;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.DataReference;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoGenerator;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyName;
import org.opensaml.xmlsec.signature.RetrievalMethod;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ComplexEncryptionTest
extends XMLObjectBaseTestCase {
    private Encrypter encrypter;
    private DataEncryptionParameters encParams;
    private List<KeyEncryptionParameters> kekParamsList;
    private KeyEncryptionParameters kekParamsRSA;
    private KeyEncryptionParameters kekParamsAES;
    private KeyInfo keyInfo;
    private KeyInfo kekKeyInfoRSA;
    private String algoURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    private String kekURIRSA = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    private String kekURIAES = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    private String expectedKeyNameRSA = "RSAKeyWrapper";
    private String expectedRecipientRSA = "RSARecipient";
    private String expectedRecipientAES = "AESRecipient";

    @BeforeMethod
    protected void setUp() throws Exception {
        Credential encCred = AlgorithmSupport.generateSymmetricKeyAndCredential((String)this.algoURI);
        Credential kekCredAES = AlgorithmSupport.generateSymmetricKeyAndCredential((String)this.kekURIAES);
        Credential kekCredRSA = AlgorithmSupport.generateKeyPairAndCredential((String)this.kekURIRSA, (int)2048, (boolean)false);
        this.encParams = new DataEncryptionParameters();
        this.encParams.setAlgorithm(this.algoURI);
        this.encParams.setEncryptionCredential(encCred);
        this.kekParamsAES = new KeyEncryptionParameters();
        this.kekParamsAES.setAlgorithm(this.kekURIAES);
        this.kekParamsAES.setEncryptionCredential(kekCredAES);
        this.kekParamsRSA = new KeyEncryptionParameters();
        this.kekParamsRSA.setAlgorithm(this.kekURIRSA);
        this.kekParamsRSA.setEncryptionCredential(kekCredRSA);
        this.kekParamsList = new ArrayList<KeyEncryptionParameters>();
        this.keyInfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        this.kekKeyInfoRSA = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
    }

    @Test
    public void testSingleKEKInline() {
        Assertion target = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml2/encryption/Assertion.xml");
        KeyName keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.expectedKeyNameRSA);
        this.kekKeyInfoRSA.getKeyNames().add(keyName);
        this.kekParamsRSA.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.kekKeyInfoRSA));
        this.kekParamsList.add(this.kekParamsRSA);
        this.encrypter = new Encrypter(this.encParams, this.kekParamsList);
        this.encrypter.setKeyPlacement(Encrypter.KeyPlacement.INLINE);
        EncryptedAssertion encTarget = null;
        EncryptedAssertion encObject = null;
        try {
            encObject = this.encrypter.encrypt(target);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject instanceof EncryptedAssertion), (String)"Encrypted object was not an instance of the expected type");
        encTarget = encObject;
        Assert.assertEquals((int)encTarget.getEncryptedData().getKeyInfo().getEncryptedKeys().size(), (int)1, (String)"Number of inline EncryptedKeys");
        Assert.assertEquals((int)encTarget.getEncryptedKeys().size(), (int)0, (String)"Number of peer EncryptedKeys");
        EncryptedKey encKey = (EncryptedKey)encTarget.getEncryptedData().getKeyInfo().getEncryptedKeys().get(0);
        Assert.assertNotNull((Object)encKey, (String)"EncryptedKey was null");
        Assert.assertEquals((String)encKey.getEncryptionMethod().getAlgorithm(), (String)this.kekURIRSA, (String)"Algorithm attribute");
        Assert.assertNotNull((Object)encKey.getKeyInfo(), (String)"KeyInfo");
        Assert.assertEquals((String)((KeyName)encKey.getKeyInfo().getKeyNames().get(0)).getValue(), (String)this.expectedKeyNameRSA, (String)"KeyName");
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)encKey.getID()), (String)"EncryptedKey ID attribute was empty");
        EncryptedData encData = encTarget.getEncryptedData();
        Assert.assertNotNull((Object)encData.getKeyInfo(), (String)"EncryptedData KeyInfo wasn't null");
        Assert.assertEquals((int)encData.getKeyInfo().getRetrievalMethods().size(), (int)0, (String)"EncryptedData improperly contained a RetrievalMethod");
        Assert.assertNull((Object)encKey.getReferenceList(), (String)"EncryptedKey ReferenceList wasn't null");
        Assert.assertNull((Object)encKey.getCarriedKeyName(), (String)"EncryptedKey CarriedKeyName wasn't null");
    }

    @Test
    public void testSingleKEKPeer() {
        Assertion target = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml2/encryption/Assertion.xml");
        KeyName keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.expectedKeyNameRSA);
        this.kekKeyInfoRSA.getKeyNames().add(keyName);
        this.kekParamsRSA.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.kekKeyInfoRSA));
        this.kekParamsList.add(this.kekParamsRSA);
        this.encrypter = new Encrypter(this.encParams, this.kekParamsList);
        this.encrypter.setKeyPlacement(Encrypter.KeyPlacement.PEER);
        EncryptedAssertion encTarget = null;
        EncryptedAssertion encObject = null;
        try {
            encObject = this.encrypter.encrypt(target);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject instanceof EncryptedAssertion), (String)"Encrypted object was not an instance of the expected type");
        encTarget = encObject;
        Assert.assertEquals((int)encTarget.getEncryptedData().getKeyInfo().getEncryptedKeys().size(), (int)0, (String)"Number of inline EncryptedKeys");
        Assert.assertEquals((int)encTarget.getEncryptedKeys().size(), (int)1, (String)"Number of peer EncryptedKeys");
        EncryptedKey encKey = (EncryptedKey)encTarget.getEncryptedKeys().get(0);
        Assert.assertNotNull((Object)encKey, (String)"EncryptedKey was null");
        Assert.assertEquals((String)encKey.getEncryptionMethod().getAlgorithm(), (String)this.kekURIRSA, (String)"Algorithm attribute");
        Assert.assertNotNull((Object)encKey.getKeyInfo(), (String)"KeyInfo");
        Assert.assertEquals((String)((KeyName)encKey.getKeyInfo().getKeyNames().get(0)).getValue(), (String)this.expectedKeyNameRSA, (String)"KeyName");
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)encKey.getID()), (String)"EncryptedKey ID attribute was empty");
        EncryptedData encData = encTarget.getEncryptedData();
        Assert.assertNotNull((Object)encData.getKeyInfo(), (String)"EncryptedData KeyInfo wasn't null");
        Assert.assertEquals((int)encData.getKeyInfo().getRetrievalMethods().size(), (int)1, (String)"EncryptedData contained invalid number RetrievalMethods");
        RetrievalMethod rm = (RetrievalMethod)encData.getKeyInfo().getRetrievalMethods().get(0);
        Assert.assertEquals((String)rm.getType(), (String)"http://www.w3.org/2001/04/xmlenc#EncryptedKey", (String)"EncryptedData RetrievalMethod had incorrect type attribute");
        Assert.assertEquals((String)rm.getURI(), (String)("#" + encKey.getID()), (String)"EncryptedData RetrievalMethod had incorrect URI value");
        Assert.assertNotNull((Object)encKey.getReferenceList(), (String)"EncryptedKey ReferenceList was null");
        Assert.assertEquals((int)encKey.getReferenceList().getDataReferences().size(), (int)1, (String)"EncryptedKey contained invalid number DataReferences");
        DataReference dr = (DataReference)encKey.getReferenceList().getDataReferences().get(0);
        Assert.assertEquals((String)dr.getURI(), (String)("#" + encData.getID()), (String)"EncryptedKey DataReference had incorrect URI value");
        Assert.assertNull((Object)encKey.getCarriedKeyName(), (String)"EncryptedKey CarriedKeyName wasn't null");
    }

    @Test
    public void testMulticastKEKPeer() {
        Assertion target = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml2/encryption/Assertion.xml");
        String multicastKeyNameValue = "MulticastDataEncryptionKeyName";
        KeyName keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(multicastKeyNameValue);
        this.keyInfo.getKeyNames().add(keyName);
        this.encParams.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.keyInfo));
        this.kekParamsRSA.setRecipient(this.expectedRecipientRSA);
        this.kekParamsList.add(this.kekParamsRSA);
        this.kekParamsAES.setRecipient(this.expectedRecipientAES);
        this.kekParamsList.add(this.kekParamsAES);
        this.encrypter = new Encrypter(this.encParams, this.kekParamsList);
        this.encrypter.setKeyPlacement(Encrypter.KeyPlacement.PEER);
        EncryptedAssertion encTarget = null;
        EncryptedAssertion encObject = null;
        try {
            encObject = this.encrypter.encrypt(target);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject instanceof EncryptedAssertion), (String)"Encrypted object was not an instance of the expected type");
        encTarget = encObject;
        Assert.assertEquals((int)encTarget.getEncryptedData().getKeyInfo().getEncryptedKeys().size(), (int)0, (String)"Number of inline EncryptedKeys");
        Assert.assertEquals((int)encTarget.getEncryptedKeys().size(), (int)2, (String)"Number of peer EncryptedKeys");
        EncryptedKey encKeyRSA = (EncryptedKey)encTarget.getEncryptedKeys().get(0);
        EncryptedKey encKeyAES = (EncryptedKey)encTarget.getEncryptedKeys().get(1);
        Assert.assertNotNull((Object)encKeyRSA, (String)"EncryptedKey was null");
        Assert.assertNotNull((Object)encKeyAES, (String)"EncryptedKey was null");
        Assert.assertEquals((String)encKeyRSA.getEncryptionMethod().getAlgorithm(), (String)this.kekURIRSA, (String)"Algorithm attribute");
        Assert.assertEquals((String)encKeyAES.getEncryptionMethod().getAlgorithm(), (String)this.kekURIAES, (String)"Algorithm attribute");
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)encKeyRSA.getID()), (String)"EncryptedKey ID attribute was empty");
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)encKeyAES.getID()), (String)"EncryptedKey ID attribute was empty");
        EncryptedData encData = encTarget.getEncryptedData();
        Assert.assertNotNull((Object)encData.getKeyInfo(), (String)"EncryptedData KeyInfo wasn't null");
        Assert.assertEquals((int)encData.getKeyInfo().getRetrievalMethods().size(), (int)0, (String)"EncryptedData contained invalid number RetrievalMethods");
        Assert.assertEquals((int)encData.getKeyInfo().getKeyNames().size(), (int)1, (String)"EncryptedData contained invalid number KeyNames");
        KeyName encDataKeyName = (KeyName)encData.getKeyInfo().getKeyNames().get(0);
        Assert.assertEquals((String)encDataKeyName.getValue(), (String)multicastKeyNameValue, (String)"EncryptedData KeyName value");
        DataReference dr = null;
        Assert.assertEquals((String)encKeyRSA.getRecipient(), (String)this.expectedRecipientRSA, (String)"EncryptedKey recipient attribute had invalid value");
        Assert.assertNotNull((Object)encKeyRSA.getReferenceList(), (String)"EncryptedKey ReferenceList was null");
        Assert.assertEquals((int)encKeyRSA.getReferenceList().getDataReferences().size(), (int)1, (String)"EncryptedKey contained invalid number DataReferences");
        dr = (DataReference)encKeyRSA.getReferenceList().getDataReferences().get(0);
        Assert.assertEquals((String)dr.getURI(), (String)("#" + encData.getID()), (String)"EncryptedKey DataReference had incorrect URI value");
        Assert.assertNotNull((Object)encKeyRSA.getCarriedKeyName(), (String)"EncryptedKey CarriedKeyName wasn't null");
        Assert.assertEquals((String)encKeyRSA.getCarriedKeyName().getValue(), (String)multicastKeyNameValue, (String)"EncrypteKey CarriedKeyName had incorrect value");
        Assert.assertEquals((String)encKeyAES.getRecipient(), (String)this.expectedRecipientAES, (String)"EncryptedKey recipient attribute had invalid value");
        Assert.assertNotNull((Object)encKeyAES.getReferenceList(), (String)"EncryptedKey ReferenceList was null");
        Assert.assertEquals((int)encKeyAES.getReferenceList().getDataReferences().size(), (int)1, (String)"EncryptedKey contained invalid number DataReferences");
        dr = (DataReference)encKeyAES.getReferenceList().getDataReferences().get(0);
        Assert.assertEquals((String)dr.getURI(), (String)("#" + encData.getID()), (String)"EncryptedKey DataReference had incorrect URI value");
        Assert.assertNotNull((Object)encKeyAES.getCarriedKeyName(), (String)"EncryptedKey CarriedKeyName wasn't null");
        Assert.assertEquals((String)encKeyAES.getCarriedKeyName().getValue(), (String)multicastKeyNameValue, (String)"EncrypteKey CarriedKeyName had incorrect value");
    }

    @Test
    public void testReuse() {
        Assertion assertion = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml2/encryption/Assertion.xml");
        Attribute target = (Attribute)((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes().get(0);
        Attribute target2 = (Attribute)((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes().get(1);
        KeyName keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.expectedKeyNameRSA);
        this.kekKeyInfoRSA.getKeyNames().add(keyName);
        this.kekParamsRSA.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.kekKeyInfoRSA));
        this.kekParamsList.add(this.kekParamsRSA);
        this.encrypter = new Encrypter(this.encParams, this.kekParamsList);
        this.encrypter.setKeyPlacement(Encrypter.KeyPlacement.PEER);
        EncryptedAttribute encObject = null;
        try {
            encObject = this.encrypter.encrypt(target);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject instanceof EncryptedAttribute), (String)"Encrypted object was not an instance of the expected type");
        EncryptedAttribute encObject2 = null;
        try {
            encObject2 = this.encrypter.encrypt(target2);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject2, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject2 instanceof EncryptedAttribute), (String)"Encrypted object was not an instance of the expected type");
    }
}

