/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SubjectConfirmationDataTest
extends XMLObjectProviderBaseTestCase {
    private DateTime expectedNotBefore;
    private DateTime expectedNotOnOrAfter;
    private String expectedRecipient;
    private String expectedInResponseTo;
    private String expectedAddress;

    public SubjectConfirmationDataTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/SubjectConfirmationData.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/SubjectConfirmationDataOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedNotBefore = new DateTime(1984, 8, 26, 10, 1, 30, 43, (Chronology)ISOChronology.getInstanceUTC());
        this.expectedNotOnOrAfter = new DateTime(1984, 8, 26, 10, 11, 30, 43, (Chronology)ISOChronology.getInstanceUTC());
        this.expectedRecipient = "recipient";
        this.expectedInResponseTo = "inresponse";
        this.expectedAddress = "address";
    }

    @Test
    public void testSingleElementUnmarshall() {
        SubjectConfirmationData subjectCD = (SubjectConfirmationData)this.unmarshallElement(this.singleElementFile);
        DateTime notBefore = subjectCD.getNotBefore();
        Assert.assertEquals((Object)notBefore, (Object)this.expectedNotBefore, (String)("NotBefore was " + notBefore + ", expected " + this.expectedNotBefore));
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        SubjectConfirmationData subjectCD = (SubjectConfirmationData)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        DateTime notBefore = subjectCD.getNotBefore();
        Assert.assertEquals((Object)notBefore, (Object)this.expectedNotBefore, (String)("NotBefore was " + notBefore + ", expected " + this.expectedNotBefore));
        DateTime notOnOrAfter = subjectCD.getNotOnOrAfter();
        Assert.assertEquals((Object)notOnOrAfter, (Object)this.expectedNotOnOrAfter, (String)("NotOnOrAfter was " + notOnOrAfter + ", expected " + this.expectedNotOnOrAfter));
        String recipient = subjectCD.getRecipient();
        Assert.assertEquals((String)recipient, (String)this.expectedRecipient, (String)("Recipient was " + recipient + ", expected " + this.expectedRecipient));
        String inResponseTo = subjectCD.getInResponseTo();
        Assert.assertEquals((String)inResponseTo, (String)this.expectedInResponseTo, (String)("InResponseTo was " + inResponseTo + ", expected " + this.expectedInResponseTo));
        String address = subjectCD.getAddress();
        Assert.assertEquals((String)address, (String)this.expectedAddress, (String)("Address was " + address + ", expected " + this.expectedAddress));
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmationData", "saml2");
        SubjectConfirmationData subjectCD = (SubjectConfirmationData)this.buildXMLObject(qname);
        subjectCD.setNotBefore(this.expectedNotBefore);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)subjectCD);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmationData", "saml2");
        SubjectConfirmationData subjectCD = (SubjectConfirmationData)this.buildXMLObject(qname);
        subjectCD.setNotBefore(this.expectedNotBefore);
        subjectCD.setNotOnOrAfter(this.expectedNotOnOrAfter);
        subjectCD.setRecipient(this.expectedRecipient);
        subjectCD.setInResponseTo(this.expectedInResponseTo);
        subjectCD.setAddress(this.expectedAddress);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)subjectCD);
    }
}

