/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.StatusCode;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StatusCodeTest
extends XMLObjectProviderBaseTestCase {
    private String expectedValue;

    public StatusCodeTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/StatusCode.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/StatusCodeChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedValue = "urn:string";
    }

    @Test
    public void testSingleElementMarshall() {
        StatusCode statusCode = (StatusCode)this.buildXMLObject(StatusCode.DEFAULT_ELEMENT_NAME);
        statusCode.setValue(this.expectedValue);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)statusCode);
    }

    @Test
    public void testChildElementsMarshall() {
        StatusCode statusCode = (StatusCode)this.buildXMLObject(StatusCode.DEFAULT_ELEMENT_NAME);
        QName statusCodeQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "StatusCode", "saml2p");
        statusCode.setStatusCode((StatusCode)this.buildXMLObject(statusCodeQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)statusCode);
    }

    @Test
    public void testSingleElementUnmarshall() {
        StatusCode statusCode = (StatusCode)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)statusCode.getValue(), (String)this.expectedValue, (String)"Unmarshalled status code URI value was not the expected value");
    }

    @Test
    public void testChildElementsUnmarshall() {
        StatusCode statusCode = (StatusCode)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)statusCode.getStatusCode());
    }
}

