/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.impl.RequestTestBase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LogoutRequestTest
extends RequestTestBase {
    private String expectedReason;
    private DateTime expectedNotOnOrAfter;
    private int expectedNumSessionIndexes;

    public LogoutRequestTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/LogoutRequest.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/LogoutRequestOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/LogoutRequestChildElements.xml";
    }

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
        this.expectedReason = "urn:string:reason";
        this.expectedNotOnOrAfter = new DateTime(2006, 2, 21, 20, 45, 0, 0, (Chronology)ISOChronology.getInstanceUTC());
        this.expectedNumSessionIndexes = 2;
    }

    @Override
    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "LogoutRequest", "saml2p");
        LogoutRequest req = (LogoutRequest)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)req);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)req);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "LogoutRequest", "saml2p");
        LogoutRequest req = (LogoutRequest)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)req);
        super.populateOptionalAttributes((SAMLObject)req);
        req.setReason(this.expectedReason);
        req.setNotOnOrAfter(this.expectedNotOnOrAfter);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)req);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "LogoutRequest", "saml2p");
        LogoutRequest req = (LogoutRequest)this.buildXMLObject(qname);
        super.populateChildElements((SAMLObject)req);
        QName nameIDQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "NameID", "saml2");
        req.setNameID((NameID)this.buildXMLObject(nameIDQName));
        QName sessionIndexQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "SessionIndex", "saml2p");
        for (int i = 0; i < this.expectedNumSessionIndexes; ++i) {
            req.getSessionIndexes().add((SessionIndex)this.buildXMLObject(sessionIndexQName));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)req);
    }

    @Override
    @Test
    public void testSingleElementUnmarshall() {
        LogoutRequest req = (LogoutRequest)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)req, (String)"LogoutRequest was null");
        Assert.assertNull((Object)req.getReason(), (String)"Reason was not null");
        Assert.assertNull((Object)req.getNotOnOrAfter(), (String)"NotOnOrAfter was not null");
        super.helperTestSingleElementUnmarshall((SAMLObject)req);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        LogoutRequest req = (LogoutRequest)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)req.getReason(), (String)this.expectedReason, (String)"Unmarshalled Reason attribute was not the expectecd value");
        Assert.assertEquals((int)this.expectedNotOnOrAfter.compareTo((ReadableInstant)req.getNotOnOrAfter()), (int)0, (String)"Unmarshalled NotOnOrAfter attribute was not the expectecd value");
        super.helperTestSingleElementOptionalAttributesUnmarshall((SAMLObject)req);
    }

    @Test
    public void testChildElementsUnmarshall() {
        LogoutRequest req = (LogoutRequest)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)req.getNameID(), (String)"Identifier was null");
        Assert.assertEquals((int)req.getSessionIndexes().size(), (int)this.expectedNumSessionIndexes, (String)"Number of unmarshalled SessionIndexes was not the expected value");
        super.helperTestChildElementsUnmarshall((SAMLObject)req);
    }
}

