/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IDPEntryTest
extends XMLObjectProviderBaseTestCase {
    private String expectedProviderID;
    private String expectedName;
    private String expectedLocation;

    public IDPEntryTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/IDPEntry.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/IDPEntryOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedProviderID = "urn:string:providerid";
        this.expectedName = "Example IdP";
        this.expectedLocation = "http://idp.example.org/endpoint";
    }

    @Test
    public void testSingleElementMarshall() {
        IDPEntry entry = (IDPEntry)this.buildXMLObject(IDPEntry.DEFAULT_ELEMENT_NAME);
        entry.setProviderID(this.expectedProviderID);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)entry);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        IDPEntry entry = (IDPEntry)this.buildXMLObject(IDPEntry.DEFAULT_ELEMENT_NAME);
        entry.setProviderID(this.expectedProviderID);
        entry.setName(this.expectedName);
        entry.setLoc(this.expectedLocation);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)entry);
    }

    @Test
    public void testSingleElementUnmarshall() {
        IDPEntry entry = (IDPEntry)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)entry.getProviderID(), (String)this.expectedProviderID, (String)"The unmarshalled ProviderID attribute was not the expected value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        IDPEntry entry = (IDPEntry)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)entry.getName(), (String)this.expectedName, (String)"The unmarshalled Name attribute was not the expected value");
        Assert.assertEquals((String)entry.getLoc(), (String)this.expectedLocation, (String)"The unmarshalled Loc (location) attribute was not the expected value");
    }
}

