/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.joda.time.DateTime;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLTestSupport;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Node;

public class SignedAssertionTest
extends XMLObjectBaseTestCase {
    private final Logger log = LoggerFactory.getLogger(SignedAssertionTest.class);
    private BasicCredential goodCredential;
    private SAMLObjectBuilder<Assertion> assertionBuilder;
    private SAMLObjectBuilder<Issuer> issuerBuilder;
    private SAMLObjectBuilder<AuthnStatement> authnStatementBuilder;
    private XMLObjectBuilder<Signature> signatureBuilder;
    private RandomIdentifierGenerationStrategy idGenerator;

    @BeforeMethod
    protected void setUp() throws Exception {
        KeyPair keyPair = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.goodCredential = CredentialSupport.getSimpleCredential((PublicKey)keyPair.getPublic(), (PrivateKey)keyPair.getPrivate());
        keyPair = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        CredentialSupport.getSimpleCredential((PublicKey)keyPair.getPublic(), null);
        this.assertionBuilder = (SAMLObjectBuilder)builderFactory.getBuilderOrThrow(Assertion.DEFAULT_ELEMENT_NAME);
        this.issuerBuilder = (SAMLObjectBuilder)builderFactory.getBuilderOrThrow(Issuer.DEFAULT_ELEMENT_NAME);
        this.authnStatementBuilder = (SAMLObjectBuilder)builderFactory.getBuilderOrThrow(AuthnStatement.DEFAULT_ELEMENT_NAME);
        this.signatureBuilder = builderFactory.getBuilderOrThrow(Signature.DEFAULT_ELEMENT_NAME);
        this.idGenerator = new RandomIdentifierGenerationStrategy();
    }

    @Test
    public void testAssertionSignature() throws MarshallingException, SignatureException, UnmarshallingException, SecurityException {
        DateTime now = new DateTime();
        Assertion assertion = (Assertion)this.assertionBuilder.buildObject();
        assertion.setVersion(SAMLVersion.VERSION_20);
        assertion.setID(this.idGenerator.generateIdentifier());
        assertion.setIssueInstant(now);
        Issuer issuer = (Issuer)this.issuerBuilder.buildObject();
        issuer.setValue("urn:example.org:issuer");
        assertion.setIssuer(issuer);
        AuthnStatement authnStmt = (AuthnStatement)this.authnStatementBuilder.buildObject();
        authnStmt.setAuthnInstant(now);
        assertion.getAuthnStatements().add(authnStmt);
        Signature signature = (Signature)this.signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)this.goodCredential);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        assertion.setSignature(signature);
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)assertion);
        marshaller.marshall((XMLObject)assertion);
        Signer.signObject((Signature)signature);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Marshalled signed assertion: \n" + SerializeSupport.nodeToString((Node)assertion.getDOM()));
        }
        Assertion signedAssertion = (Assertion)unmarshallerFactory.getUnmarshaller(assertion.getDOM()).unmarshall(assertion.getDOM());
        StaticCredentialResolver credResolver = new StaticCredentialResolver((Credential)this.goodCredential);
        KeyInfoCredentialResolver kiResolver = SAMLTestSupport.buildBasicInlineKeyInfoResolver();
        ExplicitKeySignatureTrustEngine trustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)credResolver, kiResolver);
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:example.org:issuer")});
        Assert.assertTrue((boolean)trustEngine.validate(signedAssertion.getSignature(), criteriaSet), (String)"Assertion signature was not valid");
    }
}

