/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.security.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.ChannelBindingsContext;
import org.opensaml.saml.ext.saml2cb.ChannelBindings;
import org.opensaml.saml.saml2.binding.security.impl.ExtractChannelBindingsHeadersHandler;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.util.SOAPSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ExtractChannelBindingsHeadersHandlerTest
extends OpenSAMLInitBaseTestCase {
    @Test
    public void testMissingEnvelope() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        ExtractChannelBindingsHeadersHandler handler = new ExtractChannelBindingsHeadersHandler();
        handler.initialize();
        handler.invoke(messageCtx);
        Assert.assertNull((Object)messageCtx.getSubcontext(SOAP11Context.class));
    }

    @Test
    public void testNoHeaders() throws MessageHandlerException, ComponentInitializationException {
        Envelope env = (Envelope)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Envelope.DEFAULT_ELEMENT_NAME).buildObject(Envelope.DEFAULT_ELEMENT_NAME);
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        ((SOAP11Context)messageCtx.getSubcontext(SOAP11Context.class, true)).setEnvelope(env);
        ExtractChannelBindingsHeadersHandler handler = new ExtractChannelBindingsHeadersHandler();
        handler.initialize();
        handler.invoke(messageCtx);
        ChannelBindingsContext cbCtx = (ChannelBindingsContext)((SOAP11Context)messageCtx.getSubcontext(SOAP11Context.class)).getSubcontext(ChannelBindingsContext.class);
        Assert.assertNull((Object)cbCtx);
    }

    @Test
    public void testSuccess() throws MessageHandlerException, ComponentInitializationException {
        Envelope env = (Envelope)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Envelope.DEFAULT_ELEMENT_NAME).buildObject(Envelope.DEFAULT_ELEMENT_NAME);
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        ((SOAP11Context)messageCtx.getSubcontext(SOAP11Context.class, true)).setEnvelope(env);
        ChannelBindings cb = (ChannelBindings)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME).buildObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb.setValue("foo");
        SOAPSupport.addSOAP11ActorAttribute((XMLObject)cb, (String)"http://schemas.xmlsoap.org/soap/actor/next");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)messageCtx, (XMLObject)cb);
        ChannelBindings cb2 = (ChannelBindings)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME).buildObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb2.setValue("bar");
        SOAPSupport.addSOAP11ActorAttribute((XMLObject)cb2, (String)"http://schemas.xmlsoap.org/soap/actor/next");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)messageCtx, (XMLObject)cb2);
        ExtractChannelBindingsHeadersHandler handler = new ExtractChannelBindingsHeadersHandler();
        handler.initialize();
        handler.invoke(messageCtx);
        ChannelBindingsContext cbCtx = (ChannelBindingsContext)((SOAP11Context)messageCtx.getSubcontext(SOAP11Context.class)).getSubcontext(ChannelBindingsContext.class);
        Assert.assertNotNull((Object)cbCtx);
        Assert.assertEquals((int)cbCtx.getChannelBindings().size(), (int)2);
        ChannelBindings[] array = cbCtx.getChannelBindings().toArray(new ChannelBindings[2]);
        Assert.assertTrue(("foo".equals(array[0].getValue()) || "bar".equals(array[0].getValue()) ? 1 : 0) != 0);
        Assert.assertTrue(("foo".equals(array[1].getValue()) || "bar".equals(array[1].getValue()) ? 1 : 0) != 0);
    }

    @Test
    public void testActor() throws MessageHandlerException, ComponentInitializationException {
        Envelope env = (Envelope)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Envelope.DEFAULT_ELEMENT_NAME).buildObject(Envelope.DEFAULT_ELEMENT_NAME);
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        ((SOAP11Context)messageCtx.getSubcontext(SOAP11Context.class, true)).setEnvelope(env);
        ChannelBindings cb = (ChannelBindings)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME).buildObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb.setValue("foo");
        SOAPSupport.addSOAP11ActorAttribute((XMLObject)cb, (String)"http://schemas.xmlsoap.org/soap/actor/next");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)messageCtx, (XMLObject)cb);
        ChannelBindings cb2 = (ChannelBindings)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME).buildObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb2.setValue("bar");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)messageCtx, (XMLObject)cb2);
        ExtractChannelBindingsHeadersHandler handler = new ExtractChannelBindingsHeadersHandler();
        handler.setNextDestination(false);
        handler.setFinalDestination(true);
        handler.initialize();
        handler.invoke(messageCtx);
        ChannelBindingsContext cbCtx = (ChannelBindingsContext)((SOAP11Context)messageCtx.getSubcontext(SOAP11Context.class)).getSubcontext(ChannelBindingsContext.class);
        Assert.assertNotNull((Object)cbCtx);
        Assert.assertEquals((int)cbCtx.getChannelBindings().size(), (int)1);
        ChannelBindings[] array = cbCtx.getChannelBindings().toArray(new ChannelBindings[2]);
        Assert.assertTrue((boolean)"bar".equals(array[0].getValue()));
    }
}

