/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.security.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.ChannelBindingsContext;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.ext.saml2cb.ChannelBindings;
import org.opensaml.saml.saml1.profile.SAML1ActionTestingSupport;
import org.opensaml.saml.saml2.binding.security.impl.ExtractChannelBindingsExtensionsHandler;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExtractChannelBindingsExtensionsHandlerTest
extends OpenSAMLInitBaseTestCase {
    private MessageContext messageCtx;
    private ExtractChannelBindingsExtensionsHandler handler;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.handler = new ExtractChannelBindingsExtensionsHandler();
        this.handler.initialize();
        this.messageCtx = new MessageContext();
        ((SAMLBindingContext)this.messageCtx.getSubcontext(SAMLBindingContext.class, true)).setHasBindingSignature(true);
    }

    @Test
    public void testMissingMessage() throws MessageHandlerException {
        this.handler.invoke(this.messageCtx);
        Assert.assertNull((Object)this.messageCtx.getSubcontext(ChannelBindingsContext.class));
        this.messageCtx.setMessage((Object)SAML1ActionTestingSupport.buildResponse());
        this.handler.invoke(this.messageCtx);
        Assert.assertNull((Object)this.messageCtx.getSubcontext(ChannelBindingsContext.class));
    }

    @Test
    public void testNoExtensions() throws MessageHandlerException {
        this.messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        this.handler.invoke(this.messageCtx);
        Assert.assertNull((Object)this.messageCtx.getSubcontext(ChannelBindingsContext.class));
    }

    @Test
    public void testUnsigned() throws MessageHandlerException {
        Extensions ext = (Extensions)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Extensions.DEFAULT_ELEMENT_NAME).buildObject(Extensions.DEFAULT_ELEMENT_NAME);
        this.messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        ((AuthnRequest)this.messageCtx.getMessage()).setExtensions(ext);
        ChannelBindings cb = (ChannelBindings)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME).buildObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb.setValue("foo");
        ext.getUnknownXMLObjects().add(cb);
        ChannelBindings cb2 = (ChannelBindings)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME).buildObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb2.setValue("bar");
        ext.getUnknownXMLObjects().add(cb2);
        ((SAMLBindingContext)this.messageCtx.getSubcontext(SAMLBindingContext.class)).setHasBindingSignature(false);
        this.handler.invoke(this.messageCtx);
        ChannelBindingsContext cbCtx = (ChannelBindingsContext)this.messageCtx.getSubcontext(ChannelBindingsContext.class);
        Assert.assertNull((Object)cbCtx);
    }

    @Test
    public void testSuccess() throws MessageHandlerException {
        Extensions ext = (Extensions)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Extensions.DEFAULT_ELEMENT_NAME).buildObject(Extensions.DEFAULT_ELEMENT_NAME);
        this.messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        ((AuthnRequest)this.messageCtx.getMessage()).setExtensions(ext);
        ChannelBindings cb = (ChannelBindings)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME).buildObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb.setValue("foo");
        ext.getUnknownXMLObjects().add(cb);
        ChannelBindings cb2 = (ChannelBindings)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME).buildObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb2.setValue("bar");
        ext.getUnknownXMLObjects().add(cb2);
        this.handler.invoke(this.messageCtx);
        ChannelBindingsContext cbCtx = (ChannelBindingsContext)this.messageCtx.getSubcontext(ChannelBindingsContext.class);
        Assert.assertNotNull((Object)cbCtx);
        Assert.assertEquals((int)cbCtx.getChannelBindings().size(), (int)2);
        ChannelBindings[] array = cbCtx.getChannelBindings().toArray(new ChannelBindings[2]);
        Assert.assertTrue(("foo".equals(array[0].getValue()) || "bar".equals(array[0].getValue()) ? 1 : 0) != 0);
        Assert.assertTrue(("foo".equals(array[1].getValue()) || "bar".equals(array[1].getValue()) ? 1 : 0) != 0);
    }
}

