/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.impl;

import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.binding.impl.AddRelayStateHeaderHandler;
import org.opensaml.saml.saml2.ecp.RelayState;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddRelayStateHeaderHandlerTest
extends OpenSAMLInitBaseTestCase {
    private MessageContext messageCtx;
    private AddRelayStateHeaderHandler handler;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.messageCtx = new MessageContext();
        this.handler = new AddRelayStateHeaderHandler();
        this.handler.initialize();
    }

    @Test
    public void testMissingEndpointContext() throws MessageHandlerException {
        this.handler.invoke(this.messageCtx);
        List headers = SOAPMessagingSupport.getHeaderBlock((MessageContext)this.messageCtx, (QName)RelayState.DEFAULT_ELEMENT_NAME, null, (boolean)true);
        Assert.assertTrue((boolean)headers.isEmpty());
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testMissingEnvelope() throws MessageHandlerException {
        ((SAMLBindingContext)this.messageCtx.getSubcontext(SAMLBindingContext.class, true)).setRelayState("foo");
        this.handler.invoke(this.messageCtx);
    }

    @Test
    public void testSuccess() throws MessageHandlerException {
        Envelope env = (Envelope)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Envelope.DEFAULT_ELEMENT_NAME).buildObject(Envelope.DEFAULT_ELEMENT_NAME);
        ((SOAP11Context)this.messageCtx.getSubcontext(SOAP11Context.class, true)).setEnvelope(env);
        ((SAMLBindingContext)this.messageCtx.getSubcontext(SAMLBindingContext.class, true)).setRelayState("foo");
        this.handler.invoke(this.messageCtx);
        List headers = SOAPMessagingSupport.getHeaderBlock((MessageContext)this.messageCtx, (QName)RelayState.DEFAULT_ELEMENT_NAME, null, (boolean)true);
        Assert.assertEquals((int)headers.size(), (int)1);
        Assert.assertEquals((String)((RelayState)headers.get(0)).getValue(), (String)"foo");
    }
}

