/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.DoNotCacheCondition;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConditionsTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final DateTime expectedNotBeforeDate;
    private final DateTime expectedNotOnOfAfter;

    public ConditionsTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleConditions.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleConditionsAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/ConditionsWithChildren.xml";
        this.expectedNotBeforeDate = new DateTime(1970, 1, 1, 1, 0, 0, 123, (Chronology)ISOChronology.getInstanceUTC());
        this.expectedNotOnOfAfter = new DateTime(1970, 1, 1, 0, 0, 1, 0, (Chronology)ISOChronology.getInstanceUTC());
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Conditions", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        Conditions conditions = (Conditions)this.unmarshallElement(this.singleElementFile);
        DateTime date = conditions.getNotBefore();
        Assert.assertNull((Object)date, (String)("NotBefore attribute has a value of " + date + ", expected no value"));
        date = conditions.getNotOnOrAfter();
        Assert.assertNull((Object)date, (String)("NotOnOrAfter attribute has a value of " + date + ", expected no value"));
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Conditions conditions = (Conditions)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((Object)conditions.getNotBefore(), (Object)this.expectedNotBeforeDate, (String)"NotBefore attribute ");
        Assert.assertEquals((Object)conditions.getNotOnOrAfter(), (Object)this.expectedNotOnOfAfter, (String)"NotOnOrAfter attribute ");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Conditions conditions = (Conditions)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)conditions.getAudienceRestrictionConditions().size(), (int)3, (String)"Number of AudienceRestrictionCondition elements");
        Assert.assertEquals((int)conditions.getDoNotCacheConditions().size(), (int)1, (String)"Number of DoNotCacheCondition children");
        Assert.assertEquals((int)conditions.getConditions().size(), (int)4, (String)"Wrong number of Condition children");
    }

    @Test
    public void testSingleElementMarshall() {
        Conditions conditions = (Conditions)this.buildXMLObject(this.qname);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)conditions);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Conditions conditions = (Conditions)this.buildXMLObject(this.qname);
        conditions.setNotBefore(this.expectedNotBeforeDate);
        conditions.setNotOnOrAfter(this.expectedNotOnOfAfter);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)conditions);
    }

    @Test
    public void testChildElementsMarshall() {
        Conditions conditions = (Conditions)this.buildXMLObject(this.qname);
        QName arcQname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionCondition", "saml1");
        conditions.getConditions().add((AudienceRestrictionCondition)this.buildXMLObject(arcQname));
        conditions.getConditions().add((DoNotCacheCondition)this.buildXMLObject(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "DoNotCacheCondition", "saml1")));
        conditions.getConditions().add((AudienceRestrictionCondition)this.buildXMLObject(arcQname));
        conditions.getConditions().add((AudienceRestrictionCondition)this.buildXMLObject(arcQname));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)conditions);
    }
}

