/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.support;

import java.io.File;
import java.net.URL;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.ext.saml2mdquery.AttributeQueryDescriptorType;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.metadata.support.AttributeConsumingServiceSelector;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.ServiceName;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeConsumingServiceSelectorTest
extends XMLObjectBaseTestCase {
    private String mdFileName;
    private FilesystemMetadataResolver mdProvider;
    private PredicateRoleDescriptorResolver roleResolver;
    private AttributeConsumingServiceSelector acsSelector;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.mdFileName = "/org/opensaml/saml/saml2/metadata/support/metadata-AttributeConsumingService.xml";
        URL mdURL = AttributeConsumingServiceSelectorTest.class.getResource(this.mdFileName);
        File mdFile = new File(mdURL.toURI());
        this.mdProvider = new FilesystemMetadataResolver(mdFile);
        this.mdProvider.setParserPool(parserPool);
        this.mdProvider.setId("test");
        this.mdProvider.initialize();
        this.roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)this.mdProvider);
        this.roleResolver.initialize();
        this.acsSelector = new AttributeConsumingServiceSelector();
    }

    @Test
    public void testWithValidIndex() throws ResolverException {
        RoleDescriptor role = this.roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:test:entity:A"), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)role);
        this.acsSelector.setRoleDescriptor(role);
        this.acsSelector.setIndex(Integer.valueOf(1));
        AttributeConsumingService acs = this.acsSelector.selectService();
        Assert.assertNotNull((Object)acs);
        Assert.assertEquals((String)this.getName(acs), (String)"A-SP-1", (String)"Wrong service selected");
    }

    @Test
    public void testExplicitDefault() throws ResolverException {
        RoleDescriptor role = this.roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:test:entity:A"), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)role);
        this.acsSelector.setRoleDescriptor(role);
        AttributeConsumingService acs = this.acsSelector.selectService();
        Assert.assertNotNull((Object)acs);
        Assert.assertEquals((String)this.getName(acs), (String)"A-SP-0", (String)"Wrong service selected");
    }

    @Test
    public void testFirstMissingDefault() throws ResolverException {
        RoleDescriptor role = this.roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:test:entity:B"), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)role);
        this.acsSelector.setRoleDescriptor(role);
        AttributeConsumingService acs = this.acsSelector.selectService();
        Assert.assertNotNull((Object)acs);
        Assert.assertEquals((String)this.getName(acs), (String)"B-SP-2", (String)"Wrong service selected");
    }

    @Test
    public void testFirstFalseDefault() throws ResolverException {
        RoleDescriptor role = this.roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:test:entity:C"), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)role);
        this.acsSelector.setRoleDescriptor(role);
        AttributeConsumingService acs = this.acsSelector.selectService();
        Assert.assertNotNull((Object)acs);
        Assert.assertEquals((String)this.getName(acs), (String)"C-SP-0", (String)"Wrong service selected");
    }

    @Test
    public void testAttributeQueryType() throws ResolverException {
        RoleDescriptor role = this.roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:test:entity:A"), new EntityRoleCriterion(AttributeQueryDescriptorType.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)role);
        this.acsSelector.setRoleDescriptor(role);
        this.acsSelector.setIndex(Integer.valueOf(0));
        AttributeConsumingService acs = this.acsSelector.selectService();
        Assert.assertNotNull((Object)acs);
        Assert.assertEquals((String)this.getName(acs), (String)"A-AQ-0", (String)"Wrong service selected");
    }

    @Test
    public void testInvalidIndex() throws ResolverException {
        RoleDescriptor role = this.roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:test:entity:A"), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)role);
        this.acsSelector.setRoleDescriptor(role);
        this.acsSelector.setIndex(Integer.valueOf(3));
        AttributeConsumingService acs = this.acsSelector.selectService();
        Assert.assertNull((Object)acs, (String)"Service should have been null due to invalid index");
    }

    @Test
    public void testInvalidIndexWithUseDefault() throws ResolverException {
        RoleDescriptor role = this.roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:test:entity:A"), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)role);
        this.acsSelector.setRoleDescriptor(role);
        this.acsSelector.setIndex(Integer.valueOf(3));
        this.acsSelector.setOnBadIndexUseDefault(true);
        AttributeConsumingService acs = this.acsSelector.selectService();
        Assert.assertNotNull((Object)acs);
        Assert.assertEquals((String)this.getName(acs), (String)"A-SP-0", (String)"Wrong service selected");
    }

    @Test
    public void testNoRoleDescriptor() {
        AttributeConsumingService acs = this.acsSelector.selectService();
        Assert.assertNull((Object)acs, (String)"Service should have been null due to lack of role descriptor");
    }

    private String getName(AttributeConsumingService acs) {
        return ((ServiceName)acs.getNames().get(0)).getValue();
    }
}

