/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index.impl;

import java.net.MalformedURLException;
import org.opensaml.saml.metadata.resolver.index.impl.MetadataIndexSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetadataIndexSupportTest {
    @Test
    public void testCanonicalizeLocationURI() throws MalformedURLException {
        try {
            MetadataIndexSupport.canonicalizeLocationURI(null);
            Assert.fail((String)"Should have failed on null/empty input");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            MetadataIndexSupport.canonicalizeLocationURI((String)"");
            Assert.fail((String)"Should have failed on null/empty input");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            MetadataIndexSupport.canonicalizeLocationURI((String)"   ");
            Assert.fail((String)"Should have failed on null/empty input");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        Assert.assertEquals((String)MetadataIndexSupport.canonicalizeLocationURI((String)"https://www.example.com"), (String)"https://www.example.com");
        Assert.assertEquals((String)MetadataIndexSupport.canonicalizeLocationURI((String)"HTTPS://WWW.EXAMPLE.COM:443/Foo/Bar"), (String)"https://www.example.com/Foo/Bar");
        Assert.assertEquals((String)MetadataIndexSupport.canonicalizeLocationURI((String)"https://www.example.com/foo/bar?abc=def&dog=cat#fragFrag"), (String)"https://www.example.com/foo/bar");
        Assert.assertEquals((String)MetadataIndexSupport.canonicalizeLocationURI((String)"https://someuser:somepass@www.example.com:443/foo/bar?abc=def&dog=cat#fragFrag"), (String)"https://www.example.com/foo/bar");
    }

    @Test
    public void testTrimURLPathSegment() {
        Assert.assertNull((Object)MetadataIndexSupport.trimURLPathSegment(null));
        Assert.assertNull((Object)MetadataIndexSupport.trimURLPathSegment((String)""));
        Assert.assertNull((Object)MetadataIndexSupport.trimURLPathSegment((String)"  "));
        Assert.assertNull((Object)MetadataIndexSupport.trimURLPathSegment((String)"foo"));
        Assert.assertEquals((String)MetadataIndexSupport.trimURLPathSegment((String)"/foo/bar/baz/"), (String)"/foo/bar/baz");
        Assert.assertEquals((String)MetadataIndexSupport.trimURLPathSegment((String)"/foo/bar/baz"), (String)"/foo/bar/");
        Assert.assertEquals((String)MetadataIndexSupport.trimURLPathSegment((String)"/foo/bar/"), (String)"/foo/bar");
        Assert.assertEquals((String)MetadataIndexSupport.trimURLPathSegment((String)"/foo/bar"), (String)"/foo/");
        Assert.assertEquals((String)MetadataIndexSupport.trimURLPathSegment((String)"/foo/"), (String)"/foo");
        Assert.assertEquals((String)MetadataIndexSupport.trimURLPathSegment((String)"/foo"), (String)"/");
        Assert.assertNull((Object)MetadataIndexSupport.trimURLPathSegment((String)"/"));
    }
}

