/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index.impl;

import com.google.common.base.Function;
import java.util.Set;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.metadata.resolver.index.MetadataIndexKey;
import org.opensaml.saml.metadata.resolver.index.SimpleStringMetadataIndexKey;
import org.opensaml.saml.metadata.resolver.index.impl.FunctionDrivenMetadataIndex;
import org.opensaml.saml.metadata.resolver.index.impl.SimpleStringCriteriaFunction;
import org.opensaml.saml.metadata.resolver.index.impl.SimpleStringCriterion;
import org.opensaml.saml.metadata.resolver.index.impl.UppercaseEntityIdDescriptorFunction;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FunctionDrivenMetadataIndexTest
extends OpenSAMLInitBaseTestCase {
    private FunctionDrivenMetadataIndex metadataIndex;
    private EntityDescriptor a;
    private EntityDescriptor b;
    private EntityDescriptor c;
    private MetadataIndexKey keyA;
    private MetadataIndexKey keyB;
    private MetadataIndexKey keyC;

    @BeforeClass
    protected void setUp() {
        this.metadataIndex = new FunctionDrivenMetadataIndex((Function)new UppercaseEntityIdDescriptorFunction(), (Function)new SimpleStringCriteriaFunction());
        this.a = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.a.setEntityID("urn:test:a");
        this.keyA = new SimpleStringMetadataIndexKey(this.a.getEntityID().toUpperCase());
        this.b = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.b.setEntityID("urn:test:b");
        this.keyB = new SimpleStringMetadataIndexKey(this.b.getEntityID().toUpperCase());
        this.c = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.c.setEntityID("urn:test:c");
        this.keyC = new SimpleStringMetadataIndexKey(this.c.getEntityID().toUpperCase());
    }

    @Test
    public void testGenerateKeysFromDescriptor() {
        Set keys = this.metadataIndex.generateKeys(this.a);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.keyA));
    }

    @Test
    public void testGenerateKeysFromCriteria() {
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new SimpleStringCriterion("URN:TEST:A"));
        Set keys = this.metadataIndex.generateKeys(criteriaSet);
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)keys.contains(this.keyA));
    }
}

