/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.io.BaseEncoding;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.saml.common.binding.artifact.SAMLArtifact;
import org.opensaml.saml.criterion.ArtifactCriterion;
import org.opensaml.saml.metadata.resolver.impl.SAMLArtifactURLBuilder;
import org.opensaml.saml.metadata.resolver.index.impl.SimpleStringCriterion;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0002;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SAMLArtifactURLBuilderTest {
    private SAMLArtifactURLBuilder builder = new SAMLArtifactURLBuilder();
    private String baseURL = "http://metadata.example.org/service/";
    private BaseEncoding HEX = BaseEncoding.base16().lowerCase();

    @Test
    public void testSourceIDArtifact() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String entityID = "https://www.example.com/saml";
        MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
        byte[] entityIDSourceID = sha1Digester.digest(entityID.getBytes("UTF-8"));
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        byte[] messageHandle = new byte[20];
        secureRandom.nextBytes(messageHandle);
        SAML2ArtifactType0004 sourceIDArtifact = new SAML2ArtifactType0004(new byte[]{0, 0}, entityIDSourceID, messageHandle);
        Assert.assertEquals((String)this.builder.buildURL(this.baseURL, new CriteriaSet(new Criterion[]{new ArtifactCriterion((SAMLArtifact)sourceIDArtifact)})), (String)("http://metadata.example.org/service/entities/%7Bsha1%7D" + this.HEX.encode(entityIDSourceID)));
    }

    @Test
    public void testSourceLocationArtifact() throws NoSuchAlgorithmException {
        String sourceLocation = "https://www.example.com/saml/artifactResolve1";
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        byte[] messageHandle = new byte[20];
        secureRandom.nextBytes(messageHandle);
        SAML1ArtifactType0002 sourceLocationArtifact = new SAML1ArtifactType0002(messageHandle, sourceLocation);
        Assert.assertNull((Object)this.builder.buildURL(this.baseURL, new CriteriaSet(new Criterion[]{new ArtifactCriterion((SAMLArtifact)sourceLocationArtifact)})));
    }

    @Test
    public void testNonArtifact() {
        Assert.assertNull((Object)this.builder.buildURL(this.baseURL, new CriteriaSet(new Criterion[]{new SimpleStringCriterion("blah")})));
    }
}

