/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.persist.MapLoadSaveManager;
import org.opensaml.core.xml.persist.XMLObjectLoadSaveManager;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.opensaml.saml.metadata.resolver.impl.AbstractDynamicMetadataResolver;
import org.opensaml.saml.metadata.resolver.index.impl.FunctionDrivenMetadataIndex;
import org.opensaml.saml.metadata.resolver.index.impl.RoleMetadataIndex;
import org.opensaml.saml.metadata.resolver.index.impl.SimpleStringCriteriaFunction;
import org.opensaml.saml.metadata.resolver.index.impl.SimpleStringCriterion;
import org.opensaml.saml.metadata.resolver.index.impl.UppercaseEntityIdDescriptorFunction;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractDynamicMetadataResolverTest
extends XMLObjectBaseTestCase {
    private Map<String, EntityDescriptor> sourceMap;
    private XMLObjectLoadSaveManager<EntityDescriptor> persistentCacheManager;
    private Map<String, EntityDescriptor> persistentCacheMap;
    private Function<EntityDescriptor, String> persistentCacheKeyGenerator;
    private MockDynamicResolver resolver;
    private String id1;
    private String id2;
    private String id3;
    private EntityDescriptor ed1;
    private EntityDescriptor ed2;
    private EntityDescriptor ed3;
    private Credential signingCred;
    private SignatureSigningParameters signingParams;
    private SignatureTrustEngine signatureTrustEngine;
    private SignatureValidationFilter signatureValidationFilter;

    @BeforeClass
    protected void setUpSigningSupport() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.signingCred = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
        this.signingParams = new SignatureSigningParameters();
        this.signingParams.setSigningCredential(this.signingCred);
        this.signingParams.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        this.signingParams.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        this.signingParams.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        this.signingParams.setKeyInfoGenerator(DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager().getDefaultManager().getFactory(this.signingCred).newInstance());
        this.signatureTrustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)new StaticCredentialResolver(this.signingCred), DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
        this.signatureValidationFilter = new SignatureValidationFilter(this.signatureTrustEngine);
    }

    @BeforeMethod
    protected void setUpEntityData() throws MarshallingException, IOException, SecurityException, SignatureException {
        ByteArrayOutputStream baos = null;
        this.id1 = "urn:test:entity:1";
        this.ed1 = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.ed1.setEntityID(this.id1);
        this.ed1.getRoleDescriptors().add((RoleDescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        SignatureSupport.signObject((SignableXMLObject)this.ed1, (SignatureSigningParameters)this.signingParams);
        Assert.assertTrue((boolean)this.ed1.isSigned());
        baos = new ByteArrayOutputStream();
        XMLObjectSupport.marshallToOutputStream((XMLObject)this.ed1, (OutputStream)baos);
        baos.flush();
        baos.close();
        Assert.assertNotNull((Object)this.ed1.getDOM());
        this.id2 = "urn:test:entity:2";
        this.ed2 = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.ed2.setEntityID(this.id2);
        this.ed2.getRoleDescriptors().add((RoleDescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        SignatureSupport.signObject((SignableXMLObject)this.ed2, (SignatureSigningParameters)this.signingParams);
        Assert.assertTrue((boolean)this.ed2.isSigned());
        baos = new ByteArrayOutputStream();
        XMLObjectSupport.marshallToOutputStream((XMLObject)this.ed2, (OutputStream)baos);
        baos.flush();
        baos.close();
        Assert.assertNotNull((Object)this.ed2.getDOM());
        this.id3 = "urn:test:entity:3";
        this.ed3 = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.ed3.setEntityID(this.id3);
        this.ed3.getRoleDescriptors().add((RoleDescriptor)this.buildXMLObject(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        SignatureSupport.signObject((SignableXMLObject)this.ed3, (SignatureSigningParameters)this.signingParams);
        Assert.assertTrue((boolean)this.ed3.isSigned());
        baos = new ByteArrayOutputStream();
        XMLObjectSupport.marshallToOutputStream((XMLObject)this.ed3, (OutputStream)baos);
        baos.flush();
        baos.close();
        Assert.assertNotNull((Object)this.ed3.getDOM());
    }

    @BeforeMethod
    protected void setUp() {
        this.sourceMap = new HashMap<String, EntityDescriptor>();
        this.persistentCacheMap = new HashMap<String, EntityDescriptor>();
        this.persistentCacheManager = new MapLoadSaveManager(this.persistentCacheMap);
        this.resolver = new MockDynamicResolver(this.sourceMap);
        this.resolver.setId("test123");
        this.resolver.setParserPool(XMLObjectProviderRegistrySupport.getParserPool());
    }

    @AfterMethod
    protected void tearDown() {
        if (this.resolver != null) {
            this.resolver.destroy();
        }
    }

    @Test
    public void testNoEntities() throws ComponentInitializationException, ResolverException {
        this.resolver.initialize();
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        Assert.assertNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})));
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().isEmpty());
    }

    @Test
    public void testBasicResolution() throws ComponentInitializationException, ResolverException {
        this.sourceMap.put(this.id1, this.ed1);
        this.sourceMap.put(this.id2, this.ed2);
        this.sourceMap.put(this.id3, this.ed3);
        this.resolver.initialize();
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id2)})), (Object)this.ed2);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id3)})), (Object)this.ed3);
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        Assert.assertEquals((int)((List)backingStore.getIndexedDescriptors().get(this.id1)).size(), (int)1);
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id2));
        Assert.assertEquals((int)((List)backingStore.getIndexedDescriptors().get(this.id2)).size(), (int)1);
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id3));
        Assert.assertEquals((int)((List)backingStore.getIndexedDescriptors().get(this.id3)).size(), (int)1);
    }

    @Test
    public void testClear() throws ComponentInitializationException, ResolverException {
        this.sourceMap.put(this.id1, this.ed1);
        this.sourceMap.put(this.id2, this.ed2);
        this.sourceMap.put(this.id3, this.ed3);
        this.resolver.initialize();
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id2)})), (Object)this.ed2);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id3)})), (Object)this.ed3);
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        this.resolver.clear();
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id2));
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id3));
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id2)})), (Object)this.ed2);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id3)})), (Object)this.ed3);
    }

    @Test
    public void testClearByEntityID() throws ComponentInitializationException, ResolverException {
        this.sourceMap.put(this.id1, this.ed1);
        this.sourceMap.put(this.id2, this.ed2);
        this.sourceMap.put(this.id3, this.ed3);
        this.resolver.initialize();
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id2)})), (Object)this.ed2);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id3)})), (Object)this.ed3);
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        this.resolver.clear(this.id1);
        this.resolver.clear(this.id2);
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id2));
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id3));
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id2)})), (Object)this.ed2);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id3)})), (Object)this.ed3);
    }

    @Test
    public void testNegativeLookupCache() throws ComponentInitializationException, ResolverException, InterruptedException {
        this.resolver.setNegativeLookupCacheDuration(2000L);
        this.resolver.initialize();
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        Assert.assertNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})));
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        this.sourceMap.put(this.id1, this.ed1);
        Assert.assertNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})));
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        Thread.sleep(2500L);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
    }

    @Test
    public void testGlobalClearWithNegativeLookupCache() throws ComponentInitializationException, ResolverException, InterruptedException {
        this.resolver.initialize();
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        Assert.assertNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})));
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        this.sourceMap.put(this.id1, this.ed1);
        this.resolver.clear();
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
    }

    @Test
    public void testEntityIDClearWithNegativeLookupCache() throws ComponentInitializationException, ResolverException, InterruptedException {
        this.resolver.initialize();
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        Assert.assertNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})));
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        this.sourceMap.put(this.id1, this.ed1);
        this.resolver.clear(this.id1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
    }

    @Test
    public void testDOMDropFromFetch() throws ComponentInitializationException, ResolverException {
        this.sourceMap.put(this.id1, this.ed1);
        this.resolver.initialize();
        EntityDescriptor result = this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)}));
        Assert.assertNotNull((Object)result);
        Assert.assertNull((Object)result.getDOM());
    }

    public void testBasicResolutionWithPersistentCache() throws ComponentInitializationException, ResolverException {
        this.sourceMap.put(this.id1, this.ed1);
        this.sourceMap.put(this.id2, this.ed2);
        this.sourceMap.put(this.id3, this.ed3);
        this.resolver.setPersistentCacheManager(this.persistentCacheManager);
        this.resolver.initialize();
        Assert.assertTrue((boolean)this.resolver.isPersistentCachingEnabled());
        Assert.assertEquals((int)this.persistentCacheMap.size(), (int)0);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        Assert.assertEquals((int)this.persistentCacheMap.size(), (int)1);
        String cacheKey = (String)this.resolver.getPersistentCacheKeyGenerator().apply((Object)this.ed1);
        Assert.assertTrue((boolean)this.persistentCacheMap.containsKey(cacheKey));
        Assert.assertSame((Object)this.persistentCacheMap.get(cacheKey), (Object)this.ed1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id2)})), (Object)this.ed2);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id3)})), (Object)this.ed2);
        Assert.assertEquals((int)this.persistentCacheMap.size(), (int)3);
        cacheKey = (String)this.resolver.getPersistentCacheKeyGenerator().apply((Object)this.ed2);
        Assert.assertTrue((boolean)this.persistentCacheMap.containsKey(cacheKey));
        Assert.assertSame((Object)this.persistentCacheMap.get(cacheKey), (Object)this.ed2);
        cacheKey = (String)this.resolver.getPersistentCacheKeyGenerator().apply((Object)this.ed3);
        Assert.assertTrue((boolean)this.persistentCacheMap.containsKey(cacheKey));
        Assert.assertSame((Object)this.persistentCacheMap.get(cacheKey), (Object)this.ed3);
    }

    @Test
    public void testWithPersistentCache() throws ComponentInitializationException, ResolverException {
        this.sourceMap.put(this.id1, this.ed1);
        this.sourceMap.put(this.id2, this.ed2);
        this.sourceMap.put(this.id3, this.ed3);
        this.resolver.setPersistentCacheManager(this.persistentCacheManager);
        this.resolver.initialize();
        Assert.assertTrue((boolean)this.resolver.isPersistentCachingEnabled());
        Assert.assertEquals((int)this.persistentCacheMap.size(), (int)0);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        Assert.assertEquals((int)this.persistentCacheMap.size(), (int)1);
        String cacheKey = (String)this.resolver.getPersistentCacheKeyGenerator().apply((Object)this.ed1);
        Assert.assertTrue((boolean)this.persistentCacheMap.containsKey(cacheKey));
        Assert.assertSame((Object)this.persistentCacheMap.get(cacheKey), (Object)this.ed1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id2)})), (Object)this.ed2);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id3)})), (Object)this.ed3);
        Assert.assertEquals((int)this.persistentCacheMap.size(), (int)3);
        cacheKey = (String)this.resolver.getPersistentCacheKeyGenerator().apply((Object)this.ed2);
        Assert.assertTrue((boolean)this.persistentCacheMap.containsKey(cacheKey));
        Assert.assertSame((Object)this.persistentCacheMap.get(cacheKey), (Object)this.ed2);
        cacheKey = (String)this.resolver.getPersistentCacheKeyGenerator().apply((Object)this.ed3);
        Assert.assertTrue((boolean)this.persistentCacheMap.containsKey(cacheKey));
        Assert.assertSame((Object)this.persistentCacheMap.get(cacheKey), (Object)this.ed3);
    }

    @Test
    public void testWithPersistentCacheAndSignatureValidation() throws ComponentInitializationException, ResolverException {
        this.sourceMap.put(this.id1, this.ed1);
        this.sourceMap.put(this.id2, this.ed2);
        this.sourceMap.put(this.id3, this.ed3);
        this.resolver.setPersistentCacheManager(this.persistentCacheManager);
        this.resolver.setMetadataFilter((MetadataFilter)this.signatureValidationFilter);
        this.resolver.initialize();
        Assert.assertTrue((boolean)this.resolver.isPersistentCachingEnabled());
        Assert.assertEquals((int)this.persistentCacheMap.size(), (int)0);
        Assert.assertNotNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})));
        Assert.assertEquals((String)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})).getEntityID(), (String)this.id1);
        Assert.assertEquals((int)this.persistentCacheMap.size(), (int)1);
        String cacheKey = (String)this.resolver.getPersistentCacheKeyGenerator().apply((Object)this.ed1);
        Assert.assertTrue((boolean)this.persistentCacheMap.containsKey(cacheKey));
        Assert.assertSame((Object)this.persistentCacheMap.get(cacheKey), (Object)this.ed1);
        Assert.assertNotNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id2)})));
        Assert.assertEquals((String)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id2)})).getEntityID(), (String)this.id2);
        Assert.assertNotNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id3)})));
        Assert.assertEquals((String)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id3)})).getEntityID(), (String)this.id3);
        Assert.assertEquals((int)this.persistentCacheMap.size(), (int)3);
        cacheKey = (String)this.resolver.getPersistentCacheKeyGenerator().apply((Object)this.ed2);
        Assert.assertTrue((boolean)this.persistentCacheMap.containsKey(cacheKey));
        Assert.assertSame((Object)this.persistentCacheMap.get(cacheKey), (Object)this.ed2);
        cacheKey = (String)this.resolver.getPersistentCacheKeyGenerator().apply((Object)this.ed3);
        Assert.assertTrue((boolean)this.persistentCacheMap.containsKey(cacheKey));
        Assert.assertSame((Object)this.persistentCacheMap.get(cacheKey), (Object)this.ed3);
    }

    @Test
    public void testInitFromPersistentCache() throws ComponentInitializationException, ResolverException, IOException {
        this.persistentCacheKeyGenerator = new AbstractDynamicMetadataResolver.DefaultCacheKeyGenerator();
        this.persistentCacheManager.save((String)this.persistentCacheKeyGenerator.apply((Object)this.ed1), (XMLObject)this.ed1);
        this.persistentCacheManager.save((String)this.persistentCacheKeyGenerator.apply((Object)this.ed2), (XMLObject)this.ed2);
        this.persistentCacheManager.save((String)this.persistentCacheKeyGenerator.apply((Object)this.ed3), (XMLObject)this.ed3);
        this.resolver.setPersistentCacheManager(this.persistentCacheManager);
        this.resolver.setPersistentCacheKeyGenerator(this.persistentCacheKeyGenerator);
        this.resolver.setInitializeFromPersistentCacheInBackground(false);
        this.resolver.initialize();
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        Assert.assertEquals((int)((List)backingStore.getIndexedDescriptors().get(this.id1)).size(), (int)1);
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id2));
        Assert.assertEquals((int)((List)backingStore.getIndexedDescriptors().get(this.id2)).size(), (int)1);
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id3));
        Assert.assertEquals((int)((List)backingStore.getIndexedDescriptors().get(this.id3)).size(), (int)1);
        Assert.assertTrue((boolean)this.sourceMap.isEmpty());
        for (String entityID : Lists.newArrayList((Object[])new String[]{this.id1, this.id2, this.id3})) {
            EntityDescriptor ed = this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)}));
            Assert.assertNotNull((Object)ed);
            Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
            Assert.assertNull((Object)ed.getDOM());
        }
    }

    @Test
    public void testInitFromPersistentCacheWithPredicate() throws ComponentInitializationException, ResolverException, IOException {
        this.persistentCacheKeyGenerator = new AbstractDynamicMetadataResolver.DefaultCacheKeyGenerator();
        this.persistentCacheManager.save((String)this.persistentCacheKeyGenerator.apply((Object)this.ed1), (XMLObject)this.ed1);
        this.persistentCacheManager.save((String)this.persistentCacheKeyGenerator.apply((Object)this.ed2), (XMLObject)this.ed2);
        this.persistentCacheManager.save((String)this.persistentCacheKeyGenerator.apply((Object)this.ed3), (XMLObject)this.ed3);
        this.resolver.setPersistentCacheManager(this.persistentCacheManager);
        this.resolver.setPersistentCacheKeyGenerator(this.persistentCacheKeyGenerator);
        this.resolver.setInitializeFromPersistentCacheInBackground(false);
        this.resolver.setInitializationFromCachePredicate((Predicate)new Predicate<EntityDescriptor>(){

            public boolean apply(EntityDescriptor input) {
                if (input == null) {
                    return false;
                }
                return Objects.equal((Object)AbstractDynamicMetadataResolverTest.this.id1, (Object)input.getEntityID());
            }
        });
        this.resolver.initialize();
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        Assert.assertEquals((int)((List)backingStore.getIndexedDescriptors().get(this.id1)).size(), (int)1);
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id2));
        Assert.assertFalse((boolean)backingStore.getIndexedDescriptors().containsKey(this.id3));
        Assert.assertTrue((boolean)this.sourceMap.isEmpty());
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        Assert.assertNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id2)})));
        Assert.assertNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id3)})));
    }

    @Test
    public void testInitFromPersistentCacheWithDifferingKeys() throws ComponentInitializationException, ResolverException, IOException {
        this.persistentCacheKeyGenerator = new AbstractDynamicMetadataResolver.DefaultCacheKeyGenerator();
        this.persistentCacheManager.save("one", (XMLObject)this.ed1);
        this.persistentCacheManager.save("two", (XMLObject)this.ed2);
        this.persistentCacheManager.save("three", (XMLObject)this.ed3);
        this.resolver.setPersistentCacheManager(this.persistentCacheManager);
        this.resolver.setPersistentCacheKeyGenerator(this.persistentCacheKeyGenerator);
        this.resolver.setInitializeFromPersistentCacheInBackground(false);
        this.resolver.initialize();
        Assert.assertFalse((boolean)this.persistentCacheMap.containsKey("one"));
        Assert.assertTrue((boolean)this.persistentCacheMap.containsKey(this.persistentCacheKeyGenerator.apply((Object)this.ed1)));
        Assert.assertFalse((boolean)this.persistentCacheMap.containsKey("two"));
        Assert.assertTrue((boolean)this.persistentCacheMap.containsKey(this.persistentCacheKeyGenerator.apply((Object)this.ed2)));
        Assert.assertFalse((boolean)this.persistentCacheMap.containsKey("three"));
        Assert.assertTrue((boolean)this.persistentCacheMap.containsKey(this.persistentCacheKeyGenerator.apply((Object)this.ed3)));
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id1));
        Assert.assertEquals((int)((List)backingStore.getIndexedDescriptors().get(this.id1)).size(), (int)1);
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id2));
        Assert.assertEquals((int)((List)backingStore.getIndexedDescriptors().get(this.id2)).size(), (int)1);
        Assert.assertTrue((boolean)backingStore.getIndexedDescriptors().containsKey(this.id3));
        Assert.assertEquals((int)((List)backingStore.getIndexedDescriptors().get(this.id3)).size(), (int)1);
        Assert.assertTrue((boolean)this.sourceMap.isEmpty());
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id2)})), (Object)this.ed2);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id3)})), (Object)this.ed3);
    }

    @Test
    public void testSecondaryIndexAfterEntityIDResolution() throws ComponentInitializationException, ResolverException {
        this.sourceMap.put(this.id1, this.ed1);
        HashSet<FunctionDrivenMetadataIndex> indexes = new HashSet<FunctionDrivenMetadataIndex>();
        indexes.add(new FunctionDrivenMetadataIndex((Function)new UppercaseEntityIdDescriptorFunction(), (Function)new SimpleStringCriteriaFunction()));
        this.resolver.setIndexes(indexes);
        this.resolver.initialize();
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        Optional indexedData = null;
        Assert.assertNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new SimpleStringCriterion(this.id1.toUpperCase())})));
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        indexedData = backingStore.getSecondaryIndexManager().lookupIndexedItems(new CriteriaSet(new Criterion[]{new SimpleStringCriterion(this.id1.toUpperCase())}));
        Assert.assertTrue((boolean)indexedData.isPresent());
        Assert.assertEquals((Set)((Set)indexedData.get()), (Set)Sets.newHashSet((Object[])new String[]{this.id1}));
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new SimpleStringCriterion(this.id1.toUpperCase())})), (Object)this.ed1);
    }

    @Test
    public void testSecondaryIndexAfterEntityIDResolutionMultipleResults() throws ComponentInitializationException, ResolverException {
        this.sourceMap.put(this.id1, this.ed1);
        this.sourceMap.put(this.id2, this.ed2);
        this.sourceMap.put(this.id3, this.ed3);
        HashSet<RoleMetadataIndex> indexes = new HashSet<RoleMetadataIndex>();
        indexes.add(new RoleMetadataIndex());
        this.resolver.setIndexes(indexes);
        this.resolver.initialize();
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        Optional indexedData = null;
        HashSet results = new HashSet();
        results.clear();
        Iterables.addAll(results, (Iterable)this.resolver.resolve(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)})));
        Assert.assertEquals((int)results.size(), (int)0);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
        indexedData = backingStore.getSecondaryIndexManager().lookupIndexedItems(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)}));
        Assert.assertTrue((boolean)indexedData.isPresent());
        Assert.assertEquals((Set)((Set)indexedData.get()), (Set)Sets.newHashSet((Object[])new String[]{this.id1}));
        results.clear();
        Iterables.addAll(results, (Iterable)this.resolver.resolve(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)})));
        Assert.assertEquals((int)results.size(), (int)1);
        Assert.assertEquals(results, (Set)Sets.newHashSet((Object[])new EntityDescriptor[]{this.ed1}));
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id2)})), (Object)this.ed2);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id3)})), (Object)this.ed3);
        indexedData = backingStore.getSecondaryIndexManager().lookupIndexedItems(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)}));
        Assert.assertTrue((boolean)indexedData.isPresent());
        Assert.assertEquals((Set)((Set)indexedData.get()), (Set)Sets.newHashSet((Object[])new String[]{this.id1, this.id2}));
        results.clear();
        Iterables.addAll(results, (Iterable)this.resolver.resolve(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)})));
        Assert.assertEquals((int)results.size(), (int)2);
        Assert.assertEquals(results, (Set)Sets.newHashSet((Object[])new EntityDescriptor[]{this.ed1, this.ed2}));
    }

    @Test
    public void testSecondaryLookupThenEntityID() throws ComponentInitializationException, ResolverException {
        this.sourceMap.put(this.id1.toUpperCase(), this.ed1);
        this.resolver.setSecondaryLookup(true);
        HashSet<FunctionDrivenMetadataIndex> indexes = new HashSet<FunctionDrivenMetadataIndex>();
        indexes.add(new FunctionDrivenMetadataIndex((Function)new UppercaseEntityIdDescriptorFunction(), (Function)new SimpleStringCriteriaFunction()));
        this.resolver.setIndexes(indexes);
        this.resolver.initialize();
        AbstractDynamicMetadataResolver.DynamicEntityBackingStore backingStore = this.resolver.getBackingStore();
        Optional indexedData = null;
        Assert.assertNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})));
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new SimpleStringCriterion(this.id1.toUpperCase())})), (Object)this.ed1);
        backingStore.getIndexedDescriptors().containsKey(this.id1);
        indexedData = backingStore.getSecondaryIndexManager().lookupIndexedItems(new CriteriaSet(new Criterion[]{new SimpleStringCriterion(this.id1.toUpperCase())}));
        Assert.assertTrue((boolean)indexedData.isPresent());
        Assert.assertEquals((Set)((Set)indexedData.get()), (Set)Sets.newHashSet((Object[])new String[]{this.id1}));
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.id1)})), (Object)this.ed1);
    }

    private static class MockDynamicResolver
    extends AbstractDynamicMetadataResolver {
        private Map<String, EntityDescriptor> originSourceMap;
        private boolean secondaryLookup;

        public MockDynamicResolver(Map<String, EntityDescriptor> map) {
            this(map, null);
        }

        public void setSecondaryLookup(boolean flag) {
            this.secondaryLookup = flag;
        }

        public MockDynamicResolver(Map<String, EntityDescriptor> map, Timer backgroundTaskTimer) {
            super(backgroundTaskTimer);
            this.originSourceMap = map;
        }

        protected XMLObject fetchFromOriginSource(CriteriaSet criteria) throws IOException {
            if (criteria.contains(EntityIdCriterion.class)) {
                return (XMLObject)this.originSourceMap.get(((EntityIdCriterion)criteria.get(EntityIdCriterion.class)).getEntityId());
            }
            if (this.secondaryLookup && criteria.contains(SimpleStringCriterion.class)) {
                return (XMLObject)this.originSourceMap.get(((SimpleStringCriterion)criteria.get(SimpleStringCriterion.class)).getValue());
            }
            return null;
        }
    }
}

