/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSource;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.metadata.resolver.impl.AbstractDynamicHTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.MetadataQueryProtocolRequestURLBuilder;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractDynamicHTTPMetadataResolverTest
extends XMLObjectBaseTestCase {
    private MockDynamicHTTPMetadataResolver resolver;
    private HttpClientBuilder httpClientBuilder;
    private EntityDescriptor entityDescriptor;
    private byte[] entityDescriptorBytes;

    @BeforeMethod
    public void setUp() throws Exception {
        this.httpClientBuilder = new HttpClientBuilder();
        HttpClient httpClient = this.httpClientBuilder.buildClient();
        this.entityDescriptor = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.entityDescriptor.setEntityID("https://foo1.example.org/idp/shibboleth");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLObjectSupport.marshallToOutputStream((XMLObject)this.entityDescriptor, (OutputStream)baos);
        baos.flush();
        baos.close();
        this.entityDescriptorBytes = baos.toByteArray();
        this.resolver = new MockDynamicHTTPMetadataResolver(httpClient);
        this.resolver.setId("myDynamicResolver");
        this.resolver.setParserPool(parserPool);
        this.resolver.initialize();
    }

    @AfterMethod
    public void tearDown() {
        if (this.resolver != null) {
            this.resolver.destroy();
        }
    }

    @Test
    public void testBasicRequest() throws ResolverException {
        String baseURL = "http://test.shibboleth.net:9000";
        String entityID = "https://foo1.example.org/idp/shibboleth";
        String requestURL = new MetadataQueryProtocolRequestURLBuilder(baseURL).apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)}));
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new RequestURLCriterion(requestURL)});
        EntityDescriptor ed = this.resolver.resolveSingle(criteriaSet);
        Assert.assertNotNull((Object)ed);
        Assert.assertEquals((String)ed.getEntityID(), (String)entityID);
        Assert.assertNull((Object)ed.getDOM());
    }

    @Test
    public void testResponseHandlerXMLObjectSource() throws Exception {
        AbstractDynamicHTTPMetadataResolver.BasicMetadataResponseHandler responseHandler = new AbstractDynamicHTTPMetadataResolver.BasicMetadataResponseHandler((AbstractDynamicHTTPMetadataResolver)this.resolver);
        BasicHttpResponse httpResponse = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 200, "OK");
        ByteArrayEntity entity = new ByteArrayEntity(this.entityDescriptorBytes);
        entity.setContentType((Header)new BasicHeader("Content-Type", "text/xml"));
        httpResponse.setEntity((HttpEntity)entity);
        XMLObject result = (XMLObject)responseHandler.handleResponse((HttpResponse)httpResponse);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof EntityDescriptor));
        Assert.assertTrue((boolean)result.getObjectMetadata().containsKey(XMLObjectSource.class));
        Assert.assertEquals((int)result.getObjectMetadata().get(XMLObjectSource.class).size(), (int)1);
    }

    @Test
    public void testResponseHandlerBadStatusCode() throws Exception {
        AbstractDynamicHTTPMetadataResolver.BasicMetadataResponseHandler responseHandler = new AbstractDynamicHTTPMetadataResolver.BasicMetadataResponseHandler((AbstractDynamicHTTPMetadataResolver)this.resolver);
        BasicHttpResponse httpResponse = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 500, "Internal Error");
        XMLObject result = (XMLObject)responseHandler.handleResponse((HttpResponse)httpResponse);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResponseHandlerUnsupportedContentType() throws Exception {
        AbstractDynamicHTTPMetadataResolver.BasicMetadataResponseHandler responseHandler = new AbstractDynamicHTTPMetadataResolver.BasicMetadataResponseHandler((AbstractDynamicHTTPMetadataResolver)this.resolver);
        BasicHttpResponse httpResponse = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 200, "OK");
        ByteArrayEntity entity = new ByteArrayEntity(this.entityDescriptorBytes);
        entity.setContentType((Header)new BasicHeader("Content-Type", "application/foobar"));
        httpResponse.setEntity((HttpEntity)entity);
        XMLObject result = (XMLObject)responseHandler.handleResponse((HttpResponse)httpResponse);
        Assert.assertNull((Object)result);
    }

    public static class RequestURLCriterion
    implements Criterion {
        public String requestURL;

        public RequestURLCriterion(String url) {
            this.requestURL = url;
        }
    }

    public static class MockDynamicHTTPMetadataResolver
    extends AbstractDynamicHTTPMetadataResolver {
        public MockDynamicHTTPMetadataResolver(HttpClient client) {
            super(null, client);
        }

        protected String buildRequestURL(CriteriaSet criteria) {
            return ((RequestURLCriterion)criteria.get(RequestURLCriterion.class)).requestURL;
        }
    }
}

