/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.samlec.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.ext.samlec.GeneratedKey;
import org.opensaml.saml.ext.samlec.impl.GeneratedKeyBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GeneratedKeyTest
extends XMLObjectProviderBaseTestCase {
    private String expectedValue;
    private String expectedSOAP11Actor;
    private Boolean expectedSOAP11MustUnderstand;

    public GeneratedKeyTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/samlec/impl/GeneratedKey.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedValue = "AGeneratedKey";
        this.expectedSOAP11Actor = "https://soap11actor.example.org";
        this.expectedSOAP11MustUnderstand = true;
    }

    @Test
    public void testSingleElementMarshall() {
        GeneratedKeyBuilder builder = (GeneratedKeyBuilder)builderFactory.getBuilder(GeneratedKey.DEFAULT_ELEMENT_NAME);
        GeneratedKey key = builder.buildObject();
        key.setSOAP11Actor(this.expectedSOAP11Actor);
        key.setSOAP11MustUnderstand(this.expectedSOAP11MustUnderstand);
        key.setValue(this.expectedValue);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)key);
    }

    @Test
    public void testSingleElementUnmarshall() {
        GeneratedKey key = (GeneratedKey)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((String)this.expectedValue, (String)key.getValue());
        Assert.assertEquals((Object)this.expectedSOAP11MustUnderstand, (Object)key.isSOAP11MustUnderstand(), (String)"SOAP mustUnderstand had unxpected value");
        Assert.assertEquals((String)this.expectedSOAP11Actor, (String)key.getSOAP11Actor(), (String)"SOAP actor had unxpected value");
    }
}

