/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2alg.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SigningMethodTest
extends XMLObjectProviderBaseTestCase {
    public SigningMethodTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2alg/impl/SigningMethod.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/ext/saml2alg/impl/SigningMethodOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/ext/saml2alg/impl/SigningMethodChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        SigningMethod signingMethod = (SigningMethod)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)signingMethod);
        Assert.assertEquals((String)signingMethod.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        SigningMethod signingMethod = (SigningMethod)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)signingMethod);
        Assert.assertEquals((String)signingMethod.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Assert.assertEquals((Object)signingMethod.getMinKeySize(), (Object)new Integer(2048));
        Assert.assertEquals((Object)signingMethod.getMaxKeySize(), (Object)new Integer(4096));
    }

    @Test
    public void testChildElementsUnmarshall() {
        SigningMethod signingMethod = (SigningMethod)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)signingMethod);
        Assert.assertEquals((String)signingMethod.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Assert.assertEquals((int)signingMethod.getUnknownXMLObjects().size(), (int)3);
    }

    @Test
    public void testSingleElementMarshall() {
        SigningMethod signingMethod = (SigningMethod)this.buildXMLObject(SigningMethod.DEFAULT_ELEMENT_NAME);
        signingMethod.setAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        this.assertXMLEquals(this.expectedDOM, (XMLObject)signingMethod);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        SigningMethod signingMethod = (SigningMethod)this.buildXMLObject(SigningMethod.DEFAULT_ELEMENT_NAME);
        signingMethod.setAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signingMethod.setMinKeySize(Integer.valueOf(2048));
        signingMethod.setMaxKeySize(Integer.valueOf(4096));
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)signingMethod);
    }

    @Test
    public void testChildElementsMarshall() {
        SigningMethod signingMethod = (SigningMethod)this.buildXMLObject(SigningMethod.DEFAULT_ELEMENT_NAME);
        signingMethod.setAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signingMethod.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        signingMethod.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        signingMethod.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)signingMethod);
    }
}

