/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.profile.impl.SignAssertions;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.profile.SAML1ActionTestingSupport;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SignAssertionsTest
extends OpenSAMLInitBaseTestCase {
    private SignAssertions action;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new SignAssertions();
        this.action.initialize();
        this.prc = new RequestContextBuilder().setOutboundMessage((Object)SAML2ActionTestingSupport.buildResponse()).buildProfileRequestContext();
    }

    @Test
    public void testNoOutboundMessageContext() throws Exception {
        this.prc.setOutboundMessageContext(null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoMessage() throws Exception {
        this.prc.getOutboundMessageContext().setMessage(null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testBadMessage() throws Exception {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildAttributeQueryRequest(null));
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
    }

    @Test
    public void testNoSecurityParametersContext() throws Exception {
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
    }

    @Test
    public void testNoSignatureSigningParameters() throws Exception {
        this.prc.addSubcontext((BaseContext)new SecurityParametersContext());
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
    }

    @Test
    public void testNoAssertions() throws Exception {
        SecurityParametersContext secParamCtx = new SecurityParametersContext();
        secParamCtx.setSignatureSigningParameters(new SignatureSigningParameters());
        this.prc.addSubcontext((BaseContext)secParamCtx);
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
    }

    @Test
    public void testSignSAML1Assertions() throws Exception {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildResponse());
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        ((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().add(assertion);
        SignatureSigningParameters signingParameters = new SignatureSigningParameters();
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        signingParameters.setSigningCredential((Credential)CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate()));
        signingParameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signingParameters.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        signingParameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        SecurityParametersContext secParamCtx = new SecurityParametersContext();
        secParamCtx.setSignatureSigningParameters(signingParameters);
        this.prc.addSubcontext((BaseContext)secParamCtx);
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
    }

    @Test
    public void testSignSAML2Assertions() throws Exception {
        org.opensaml.saml.saml2.core.Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        ((org.opensaml.saml.saml2.core.Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().add(assertion);
        SignatureSigningParameters signingParameters = new SignatureSigningParameters();
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        signingParameters.setSigningCredential((Credential)CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate()));
        signingParameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signingParameters.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        signingParameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        SecurityParametersContext secParamCtx = new SecurityParametersContext();
        secParamCtx.setSignatureSigningParameters(signingParameters);
        this.prc.addSubcontext((BaseContext)secParamCtx);
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
    }
}

