/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.profile.impl.AddInResponseToToResponse;
import org.opensaml.saml.saml1.core.RequestAbstractType;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.profile.SAML1ActionTestingSupport;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddInResponseToToResponseTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;

    @BeforeMethod
    public void setUp() {
        this.prc = new RequestContextBuilder().setInboundMessage((Object)SAML1ActionTestingSupport.buildAttributeQueryRequest(null)).buildProfileRequestContext();
    }

    @Test
    public void testNoResponse() throws ComponentInitializationException {
        AddInResponseToToResponse action = new AddInResponseToToResponse();
        action.initialize();
        action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoRequestID() throws Exception {
        ((RequestAbstractType)this.prc.getInboundMessageContext().getMessage()).setID(null);
        Response response = SAML1ActionTestingSupport.buildResponse();
        this.prc.getOutboundMessageContext().setMessage((Object)response);
        AddInResponseToToResponse action = new AddInResponseToToResponse();
        action.initialize();
        action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNull((Object)response.getInResponseTo());
    }

    @Test
    public void testSAML1Response() throws Exception {
        Response response = SAML1ActionTestingSupport.buildResponse();
        this.prc.getOutboundMessageContext().setMessage((Object)response);
        AddInResponseToToResponse action = new AddInResponseToToResponse();
        action.initialize();
        action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertEquals((String)response.getInResponseTo(), (String)"request");
    }

    @Test
    public void testSAML2Response() throws Exception {
        LogoutResponse response = SAML2ActionTestingSupport.buildLogoutResponse();
        this.prc.getOutboundMessageContext().setMessage((Object)response);
        AddInResponseToToResponse action = new AddInResponseToToResponse();
        action.initialize();
        action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertEquals((String)response.getInResponseTo(), (String)"request");
    }
}

