/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.impl.SAMLMetadataLookupHandler;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLPresenterEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.saml1.core.AttributeQuery;
import org.opensaml.saml.saml1.core.Request;
import org.opensaml.saml.saml1.profile.SAML1ActionTestingSupport;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAMLMetadataLookupHandlerTest
extends XMLObjectBaseTestCase {
    private PredicateRoleDescriptorResolver roleResolver;
    private SAMLMetadataLookupHandler handler;
    private MessageContext<SAMLObject> messageContext;

    @BeforeClass
    public void classSetUp() throws ResolverException, URISyntaxException, ComponentInitializationException {
        URL mdURL = SAMLMetadataLookupHandlerTest.class.getResource("/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
        File mdFile = new File(mdURL.toURI());
        FilesystemMetadataResolver metadataProvider = new FilesystemMetadataResolver(mdFile);
        metadataProvider.setParserPool(parserPool);
        metadataProvider.setId("test");
        metadataProvider.initialize();
        this.roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)metadataProvider);
        this.roleResolver.initialize();
    }

    @BeforeMethod
    public void setUp() {
        this.handler = new SAMLMetadataLookupHandler();
        this.messageContext = new MessageContext();
    }

    @Test
    public void testConfigFailure() {
        try {
            this.handler.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        try {
            this.handler.setRoleDescriptorResolver(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingContexts() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setRoleDescriptorResolver((RoleDescriptorResolver)this.roleResolver);
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        Assert.assertNull((Object)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, false));
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        peerContext.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.handler.invoke(this.messageContext);
        Assert.assertNull((Object)this.messageContext.getSubcontext(SAMLMetadataContext.class, false));
    }

    @Test
    public void testNotFound() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setRoleDescriptorResolver((RoleDescriptorResolver)this.roleResolver);
        this.handler.initialize();
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        peerContext.setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        Request request = SAML1ActionTestingSupport.buildAttributeQueryRequest(null);
        ((AttributeQuery)request.getQuery()).setResource("urn:notfound");
        this.messageContext.setMessage((Object)request);
        this.handler.invoke(this.messageContext);
        Assert.assertNull((Object)peerContext.getSubcontext(SAMLMetadataContext.class, false));
    }

    @Test
    public void testBadRole() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setRoleDescriptorResolver((RoleDescriptorResolver)this.roleResolver);
        this.handler.initialize();
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        peerContext.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        Request request = SAML1ActionTestingSupport.buildAttributeQueryRequest(null);
        ((AttributeQuery)request.getQuery()).setResource("urn:mace:incommon:osu.edu");
        this.messageContext.setMessage((Object)request);
        this.handler.invoke(this.messageContext);
        Assert.assertNull((Object)peerContext.getSubcontext(SAMLMetadataContext.class, false));
    }

    @Test
    public void testBadProtocol() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setRoleDescriptorResolver((RoleDescriptorResolver)this.roleResolver);
        this.handler.initialize();
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        peerContext.setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        ((SAMLProtocolContext)this.messageContext.getSubcontext(SAMLProtocolContext.class, true)).setProtocol("urn:foo");
        Request request = SAML1ActionTestingSupport.buildAttributeQueryRequest(null);
        ((AttributeQuery)request.getQuery()).setResource("urn:mace:incommon:osu.edu");
        this.messageContext.setMessage((Object)request);
        this.handler.invoke(this.messageContext);
        Assert.assertNull((Object)peerContext.getSubcontext(SAMLMetadataContext.class, false));
    }

    @Test
    public void testSuccess() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setRoleDescriptorResolver((RoleDescriptorResolver)this.roleResolver);
        this.handler.initialize();
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        peerContext.setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        ((SAMLProtocolContext)this.messageContext.getSubcontext(SAMLProtocolContext.class, true)).setProtocol("urn:oasis:names:tc:SAML:1.1:protocol");
        Request request = SAML1ActionTestingSupport.buildAttributeQueryRequest(null);
        ((AttributeQuery)request.getQuery()).setResource("urn:mace:incommon:osu.edu");
        this.messageContext.setMessage((Object)request);
        this.handler.invoke(this.messageContext);
        SAMLMetadataContext mdCtx = (SAMLMetadataContext)peerContext.getSubcontext(SAMLMetadataContext.class, false);
        Assert.assertNotNull((Object)mdCtx);
        Assert.assertNotNull((Object)mdCtx.getRoleDescriptor());
        Assert.assertNotNull((Object)mdCtx.getEntityDescriptor());
    }

    @Test
    public void testSuccessWithContextClass() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setEntityContextClass(SAMLPresenterEntityContext.class);
        this.handler.setRoleDescriptorResolver((RoleDescriptorResolver)this.roleResolver);
        this.handler.initialize();
        SAMLPresenterEntityContext presenterContext = (SAMLPresenterEntityContext)this.messageContext.getSubcontext(SAMLPresenterEntityContext.class, true);
        presenterContext.setEntityId("https://carmenwiki.osu.edu/shibboleth");
        presenterContext.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        ((SAMLProtocolContext)this.messageContext.getSubcontext(SAMLProtocolContext.class, true)).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        AuthnRequest authnRequest = SAML2ActionTestingSupport.buildAuthnRequest();
        authnRequest.getIssuer().setValue("https://carmenwiki.osu.edu/shibboleth");
        this.messageContext.setMessage((Object)authnRequest);
        this.handler.invoke(this.messageContext);
        SAMLMetadataContext mdCtx = (SAMLMetadataContext)presenterContext.getSubcontext(SAMLMetadataContext.class, false);
        Assert.assertNotNull((Object)mdCtx);
        Assert.assertNotNull((Object)mdCtx.getRoleDescriptor());
        Assert.assertNotNull((Object)mdCtx.getEntityDescriptor());
    }
}

