/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.joda.time.DateTime;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Artifact;
import org.opensaml.saml.saml2.core.ArtifactResolve;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;

public class SAML2ActionTestingSupport {
    public static final String REQUEST_ID = "request";
    public static final String RESPONSE_ID = "response";
    public static final String ASSERTION_ID = "assertion";

    @Nonnull
    public static Response buildResponse() {
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Response.DEFAULT_ELEMENT_NAME);
        Response response = (Response)responseBuilder.buildObject();
        response.setID("outbound");
        response.setIssueInstant(new DateTime(0L));
        response.setVersion(SAMLVersion.VERSION_20);
        return response;
    }

    @Nonnull
    public static ArtifactResponse buildArtifactResponse() {
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ArtifactResponse.DEFAULT_ELEMENT_NAME);
        ArtifactResponse response = (ArtifactResponse)responseBuilder.buildObject();
        response.setID("outbound");
        response.setIssueInstant(new DateTime(0L));
        response.setVersion(SAMLVersion.VERSION_20);
        return response;
    }

    @Nonnull
    public static LogoutRequest buildLogoutRequest(@Nullable NameID name) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Issuer.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder reqBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(LogoutRequest.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue("http://sp.example.org");
        LogoutRequest req = (LogoutRequest)reqBuilder.buildObject();
        req.setID(REQUEST_ID);
        req.setIssueInstant(new DateTime(0L));
        req.setIssuer(issuer);
        req.setVersion(SAMLVersion.VERSION_20);
        if (name != null) {
            req.setNameID(name);
        }
        return req;
    }

    @Nonnull
    public static LogoutResponse buildLogoutResponse() {
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(LogoutResponse.DEFAULT_ELEMENT_NAME);
        LogoutResponse response = (LogoutResponse)responseBuilder.buildObject();
        response.setID("outbound");
        response.setIssueInstant(new DateTime(0L));
        response.setVersion(SAMLVersion.VERSION_20);
        return response;
    }

    @Nonnull
    public static Assertion buildAssertion() {
        SAMLObjectBuilder assertionBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = (Assertion)assertionBuilder.buildObject();
        assertion.setID(ASSERTION_ID);
        assertion.setIssueInstant(new DateTime(0L));
        assertion.setVersion(SAMLVersion.VERSION_20);
        return assertion;
    }

    @Nonnull
    public static AuthnStatement buildAuthnStatement() {
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AuthnStatement.DEFAULT_ELEMENT_NAME);
        AuthnStatement statement = (AuthnStatement)statementBuilder.buildObject();
        statement.setAuthnInstant(new DateTime(0L));
        return statement;
    }

    @Nonnull
    public static AttributeStatement buildAttributeStatement() {
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AttributeStatement.DEFAULT_ELEMENT_NAME);
        AttributeStatement statement = (AttributeStatement)statementBuilder.buildObject();
        return statement;
    }

    @Nonnull
    public static Subject buildSubject(@Nullable String principalName) {
        SAMLObjectBuilder subjectBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)subjectBuilder.buildObject();
        if (principalName != null) {
            subject.setNameID(SAML2ActionTestingSupport.buildNameID(principalName));
        }
        return subject;
    }

    @Nonnull
    public static NameID buildNameID(@Nonnull @NotEmpty String principalName) {
        SAMLObjectBuilder nameIdBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameId = (NameID)nameIdBuilder.buildObject();
        nameId.setValue(principalName);
        return nameId;
    }

    @Nonnull
    public static Issuer buildIssuer(@Nonnull @NotEmpty String entityID) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(entityID);
        return issuer;
    }

    @Nonnull
    public static AttributeQuery buildAttributeQueryRequest(@Nullable Subject subject) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Issuer.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder queryBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AttributeQuery.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue("http://sp.example.org");
        AttributeQuery query = (AttributeQuery)queryBuilder.buildObject();
        query.setID(REQUEST_ID);
        query.setIssueInstant(new DateTime(0L));
        query.setIssuer(issuer);
        query.setVersion(SAMLVersion.VERSION_20);
        if (subject != null) {
            query.setSubject(subject);
        }
        return query;
    }

    @Nonnull
    public static AuthnRequest buildAuthnRequest() {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Issuer.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AuthnRequest.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue("http://sp.example.org");
        AuthnRequest request = (AuthnRequest)requestBuilder.buildObject();
        request.setID(REQUEST_ID);
        request.setIssueInstant(new DateTime(0L));
        request.setIssuer(issuer);
        request.setVersion(SAMLVersion.VERSION_20);
        return request;
    }

    @Nonnull
    public static ArtifactResolve buildArtifactResolve(@Nullable String artifact) {
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ArtifactResolve.DEFAULT_ELEMENT_NAME);
        ArtifactResolve request = (ArtifactResolve)requestBuilder.buildObject();
        request.setID(REQUEST_ID);
        request.setIssueInstant(new DateTime(0L));
        request.setVersion(SAMLVersion.VERSION_11);
        if (artifact != null) {
            SAMLObjectBuilder artifactBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Artifact.DEFAULT_ELEMENT_NAME);
            Artifact art = (Artifact)artifactBuilder.buildObject();
            art.setArtifact(artifact);
            request.setArtifact(art);
        }
        return request;
    }
}

