/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.profile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AssertionArtifact;
import org.opensaml.saml.saml1.core.AttributeQuery;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.core.Query;
import org.opensaml.saml.saml1.core.Request;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Subject;

public class SAML1ActionTestingSupport {
    public static final String REQUEST_ID = "request";
    public static final String RESPONSE_ID = "response";
    public static final String ASSERTION_ID = "assertion";

    @Nonnull
    public static Response buildResponse() {
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Response.DEFAULT_ELEMENT_NAME);
        Response response = (Response)responseBuilder.buildObject();
        response.setID("outbound");
        response.setIssueInstant(new DateTime(0L));
        response.setVersion(SAMLVersion.VERSION_11);
        return response;
    }

    @Nonnull
    public static Assertion buildAssertion() {
        SAMLObjectBuilder assertionBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = (Assertion)assertionBuilder.buildObject();
        assertion.setID(ASSERTION_ID);
        assertion.setIssueInstant(new DateTime(0L));
        assertion.setVersion(SAMLVersion.VERSION_11);
        return assertion;
    }

    @Nonnull
    public static AuthenticationStatement buildAuthenticationStatement() {
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AuthenticationStatement.DEFAULT_ELEMENT_NAME);
        AuthenticationStatement statement = (AuthenticationStatement)statementBuilder.buildObject();
        statement.setAuthenticationInstant(new DateTime(0L));
        statement.setAuthenticationMethod("urn:oasis:names:tc:SAML:1.0:am:password");
        return statement;
    }

    @Nonnull
    public static AttributeStatement buildAttributeStatement() {
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AttributeStatement.DEFAULT_ELEMENT_NAME);
        AttributeStatement statement = (AttributeStatement)statementBuilder.buildObject();
        return statement;
    }

    @Nonnull
    public static Subject buildSubject(@Nullable String principalName) {
        SAMLObjectBuilder subjectBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)subjectBuilder.buildObject();
        if (principalName != null) {
            SAMLObjectBuilder nameIdBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameIdentifier.DEFAULT_ELEMENT_NAME);
            NameIdentifier nameId = (NameIdentifier)nameIdBuilder.buildObject();
            nameId.setValue(principalName);
            subject.setNameIdentifier(nameId);
        }
        return subject;
    }

    @Nonnull
    public static Request buildAttributeQueryRequest(@Nullable Subject subject) {
        SAMLObjectBuilder queryBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AttributeQuery.DEFAULT_ELEMENT_NAME);
        AttributeQuery query = (AttributeQuery)queryBuilder.buildObject();
        if (subject != null) {
            query.setSubject(subject);
        }
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Request.DEFAULT_ELEMENT_NAME);
        Request request = (Request)requestBuilder.buildObject();
        request.setID(REQUEST_ID);
        request.setIssueInstant(new DateTime(0L));
        request.setQuery((Query)query);
        request.setVersion(SAMLVersion.VERSION_11);
        return request;
    }

    @Nonnull
    public static Request buildArtifactRequest(String ... artifacts) {
        SAMLObjectBuilder artifactBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AssertionArtifact.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Request.DEFAULT_ELEMENT_NAME);
        Request request = (Request)requestBuilder.buildObject();
        request.setID(REQUEST_ID);
        request.setIssueInstant(new DateTime(0L));
        request.setVersion(SAMLVersion.VERSION_11);
        if (artifacts != null) {
            for (String artifact : artifacts) {
                AssertionArtifact aa = (AssertionArtifact)artifactBuilder.buildObject();
                aa.setAssertionArtifact(artifact);
                request.getAssertionArtifacts().add(aa);
            }
        }
        return request;
    }
}

