/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.logic;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.logic.MessageContextPredicateAdapter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MessageContextPredicateAdapterTest {
    @Test
    public void testBasic() {
        MessageContext mc = new MessageContext();
        ProfileRequestContext prc = new ProfileRequestContext();
        MockPredicate wrapped = new MockPredicate();
        MessageContextPredicateAdapter adapter = new MessageContextPredicateAdapter((Predicate)wrapped);
        mc.addSubcontext((BaseContext)new MockContext());
        prc.setOutboundMessageContext(mc);
        Assert.assertTrue((boolean)adapter.apply(mc));
        mc.clearSubcontexts();
        Assert.assertFalse((boolean)adapter.apply(mc));
        Assert.assertFalse((boolean)adapter.apply(null));
        mc = new MessageContext();
        mc.addSubcontext((BaseContext)new MockContext());
        Assert.assertFalse((boolean)adapter.apply(mc));
        adapter = new MessageContextPredicateAdapter((Predicate)wrapped, true);
        Assert.assertTrue((boolean)adapter.apply(mc));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testCtor() {
        new MessageContextPredicateAdapter(null);
    }

    public static class MockPredicate
    implements Predicate<ProfileRequestContext> {
        public boolean apply(@Nullable ProfileRequestContext input) {
            if (input == null || input.getOutboundMessageContext() == null) {
                return false;
            }
            return input.getOutboundMessageContext().containsSubcontext(MockContext.class);
        }
    }

    public static class MockContext
    extends BaseContext {
        public String value;
    }
}

