/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.transport.http;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.internal.transport.http.DelegatingSSLSocketFactory;
import org.openrewrite.jgit.transport.http.HttpConnection;
import org.openrewrite.jgit.transport.http.HttpConnectionFactory2;
import org.openrewrite.jgit.transport.http.JDKHttpConnection;
import org.openrewrite.jgit.transport.http.NoCheckX509TrustManager;
import org.openrewrite.jgit.util.HttpSupport;

public class JDKHttpConnectionFactory
implements HttpConnectionFactory2 {
    @Override
    public HttpConnection create(URL url) throws IOException {
        return new JDKHttpConnection(url);
    }

    @Override
    public HttpConnection create(URL url, Proxy proxy) throws IOException {
        return new JDKHttpConnection(url, proxy);
    }

    @Override
    public HttpConnectionFactory2.GitSession newSession() {
        return new JdkConnectionSession();
    }

    private static class JdkConnectionSession
    implements HttpConnectionFactory2.GitSession {
        private SSLContext securityContext;
        private SSLSocketFactory socketFactory;

        private JdkConnectionSession() {
        }

        @Override
        public JDKHttpConnection configure(HttpConnection connection, boolean sslVerify) throws GeneralSecurityException {
            if (!(connection instanceof JDKHttpConnection)) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().httpWrongConnectionType, JDKHttpConnection.class.getName(), connection.getClass().getName()));
            }
            JDKHttpConnection conn = (JDKHttpConnection)connection;
            String scheme = conn.getURL().getProtocol();
            if (!"https".equals(scheme) || sslVerify) {
                return conn;
            }
            if (this.securityContext == null) {
                this.securityContext = SSLContext.getInstance("TLS");
                TrustManager[] trustAllCerts = new TrustManager[]{new NoCheckX509TrustManager()};
                this.securityContext.init(null, trustAllCerts, null);
                this.socketFactory = new DelegatingSSLSocketFactory(this.securityContext.getSocketFactory()){

                    @Override
                    protected void configure(SSLSocket socket) {
                        HttpSupport.configureTLS(socket);
                    }
                };
            }
            conn.setHostnameVerifier((name, session) -> true);
            ((HttpsURLConnection)conn.wrappedUrlConnection).setSSLSocketFactory(this.socketFactory);
            return conn;
        }

        @Override
        public void close() {
            this.securityContext = null;
            this.socketFactory = null;
        }
    }
}

