/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.internal.storage.pack;

import java.util.concurrent.locks.ReentrantLock;
import org.openrewrite.jgit.internal.storage.pack.DeltaCache;
import org.openrewrite.jgit.internal.storage.pack.ObjectToPack;
import org.openrewrite.jgit.storage.pack.PackConfig;

class ThreadSafeDeltaCache
extends DeltaCache {
    private final ReentrantLock lock = new ReentrantLock();

    ThreadSafeDeltaCache(PackConfig pc) {
        super(pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean canCache(int length, ObjectToPack src, ObjectToPack res) {
        this.lock.lock();
        try {
            boolean bl = super.canCache(length, src, res);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    void credit(int reservedSize) {
        this.lock.lock();
        try {
            super.credit(reservedSize);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    DeltaCache.Ref cache(byte[] data, int actLen, int reservedSize) {
        data = this.resize(data, actLen);
        this.lock.lock();
        try {
            DeltaCache.Ref ref = super.cache(data, actLen, reservedSize);
            return ref;
        }
        finally {
            this.lock.unlock();
        }
    }
}

