/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import org.openrewrite.jgit.api.GitCommand;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.lib.StoredConfig;
import org.openrewrite.jgit.transport.RemoteConfig;

public class RemoteRemoveCommand
extends GitCommand<RemoteConfig> {
    private String remoteName;

    protected RemoteRemoveCommand(Repository repo) {
        super(repo);
    }

    @Deprecated
    public void setName(String name) {
        this.remoteName = name;
    }

    public RemoteRemoveCommand setRemoteName(String remoteName) {
        this.remoteName = remoteName;
        return this;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.remoteName);
            config.unsetSection("remote", this.remoteName);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

