/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.inclusion;

import de.danielbechler.diff.path.NodePath;
import de.danielbechler.diff.selector.ElementSelector;
import de.danielbechler.diff.selector.RootElementSelector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValueNode<V> {
    protected final Map<ElementSelector, ValueNode<V>> children = new HashMap<ElementSelector, ValueNode<V>>();
    protected final ValueNode<V> parent;
    protected final ElementSelector elementSelector;
    protected V value;

    public ValueNode() {
        this(RootElementSelector.getInstance(), null);
    }

    protected ValueNode(ElementSelector elementSelector, ValueNode<V> parent) {
        this.elementSelector = elementSelector;
        this.parent = parent;
    }

    public ElementSelector getElementSelector() {
        return this.elementSelector;
    }

    public ValueNode<V> getParent() {
        return this.parent;
    }

    public ValueNode<V> getNodeForPath(NodePath nodePath) {
        if (this.parent == null) {
            List<ElementSelector> elementSelectors = nodePath.getElementSelectors();
            if (elementSelectors.size() != 1) {
                return this.getChild(elementSelectors.subList(1, elementSelectors.size()));
            }
            return this;
        }
        return this.parent.getNodeForPath(nodePath);
    }

    public ValueNode<V> getChild(ElementSelector childSelector) {
        if (childSelector == RootElementSelector.getInstance()) {
            throw new IllegalArgumentException("A child node can never be the root");
        }
        if (this.children.containsKey(childSelector)) {
            return this.children.get(childSelector);
        }
        ValueNode<V> childNode = this.newNode(childSelector);
        this.children.put(childSelector, childNode);
        return childNode;
    }

    protected ValueNode<V> newNode(ElementSelector childSelector) {
        return new ValueNode<V>(childSelector, this);
    }

    private ValueNode<V> getChild(List<ElementSelector> childSelectors) {
        if (childSelectors.size() == 1) {
            return this.getChild(childSelectors.get(0));
        }
        ValueNode<V> child = this.getChild(childSelectors.get(0));
        return super.getChild(childSelectors.subList(1, childSelectors.size()));
    }

    public boolean hasChild(ElementSelector childSelector) {
        return this.children.get(childSelector) != null;
    }

    public ValueNode<V> getClosestParentWithValue() {
        if (this.parent != null) {
            if (this.parent.hasValue()) {
                return this.parent;
            }
            return this.parent.getClosestParentWithValue();
        }
        return null;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean containsValue(V value) {
        if (this.value == value) {
            return true;
        }
        for (ValueNode<V> child : this.children.values()) {
            if (!child.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }
}

