/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.concurrent.atomic.AtomicInteger;
import org.openrewrite.Tree;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class CountLinesVisitor
extends XmlVisitor<AtomicInteger> {
    @Override
    public Xml visitDocument(Xml.Document document, AtomicInteger count) {
        count.incrementAndGet();
        return super.visitDocument(document, count);
    }

    @Override
    public Xml visitXmlDecl(Xml.XmlDecl xmlDecl, AtomicInteger count) {
        if (xmlDecl.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitXmlDecl(xmlDecl, count);
    }

    @Override
    public Xml visitProcessingInstruction(Xml.ProcessingInstruction processingInstruction, AtomicInteger count) {
        if (processingInstruction.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitProcessingInstruction(processingInstruction, count);
    }

    @Override
    public Xml visitElement(Xml.Element element, AtomicInteger count) {
        if (element.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitElement(element, count);
    }

    @Override
    public Xml visitAttribute(Xml.Attribute attribute, AtomicInteger count) {
        if (attribute.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitAttribute(attribute, count);
    }

    @Override
    public Xml visitTag(Xml.Tag tag, AtomicInteger count) {
        if (tag.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitTag(tag, count);
    }

    @Override
    public Xml visitTagClosing(Xml.Tag.Closing closing, AtomicInteger count) {
        if (closing.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitTagClosing(closing, count);
    }

    @Override
    public Xml visitComment(Xml.Comment comment, AtomicInteger count) {
        if (comment.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitComment(comment, count);
    }

    @Override
    public Xml visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl, AtomicInteger count) {
        if (docTypeDecl.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitDocTypeDecl(docTypeDecl, count);
    }

    @Override
    public Xml visitProlog(Xml.Prolog prolog, AtomicInteger count) {
        if (prolog.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitProlog(prolog, count);
    }

    @Override
    public Xml visitIdent(Xml.Ident ident, AtomicInteger count) {
        if (ident.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitIdent(ident, count);
    }

    public static int countLines(Tree tree) {
        return ((AtomicInteger)new CountLinesVisitor().reduce(tree, new AtomicInteger())).get();
    }
}

