/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.format.AutodetectGeneralFormatStyle;
import org.openrewrite.xml.format.NormalizeLineBreaksVisitor;
import org.openrewrite.xml.tree.Xml;

public class NormalizeLineBreaks
extends Recipe {
    public String getDisplayName() {
        return "Normalize line breaks";
    }

    public String getDescription() {
        return "Consistently use either Windows style (CRLF) or Linux style (LF) line breaks. If no `GeneralFormatStyle` is specified this will use whichever style of line endings are more common.";
    }

    public LineBreaksFromCompilationUnitStyle getVisitor() {
        return new LineBreaksFromCompilationUnitStyle();
    }

    private static class LineBreaksFromCompilationUnitStyle
    extends XmlIsoVisitor<ExecutionContext> {
        private LineBreaksFromCompilationUnitStyle() {
        }

        @Override
        public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
            GeneralFormatStyle generalFormatStyle = (GeneralFormatStyle)document.getStyle(GeneralFormatStyle.class);
            if (generalFormatStyle == null) {
                generalFormatStyle = AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(document);
            }
            this.doAfterVisit(new NormalizeLineBreaksVisitor(generalFormatStyle));
            return document;
        }
    }
}

