/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.security;

import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.security.IsOwaspSuppressionsFile;
import org.openrewrite.xml.tree.Xml;

public final class UpdateOwaspSuppressionDate
extends Recipe {
    @Option(displayName="CVE List", description="Update suppressions having any of the specified CVE tags.", example="CVE-2022-1234")
    private final List<String> cveList;
    @Option(displayName="Until date", required=false, description="Optional. The date to add to the suppression. Default will be 30 days from today.", example="2023-01-01")
    private final @Nullable String untilDate;

    public String getDisplayName() {
        return "Update OWASP suppression date bounds";
    }

    public String getDescription() {
        return "Updates the expiration date for OWASP suppressions having a matching cve tag. For use with the OWASP `dependency-check` tool. More details: https://jeremylong.github.io/DependencyCheck/general/suppression.html.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"untilDate", (String)"Must be empty or a valid date of format yyyy-MM-dd", (Object)this.untilDate, date -> {
            if (date != null && !date.isEmpty()) {
                try {
                    LocalDate.parse(date);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsOwaspSuppressionsFile(), (TreeVisitor)new XmlIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml t = super.visitTag(tag, ctx);
                if (new XPathMatcher("/suppressions/suppress").matches(this.getCursor())) {
                    boolean hasCve = false;
                    List<Xml.Tag> cveTags = ((Xml.Tag)t).getChildren("cve");
                    block0: for (Xml.Tag xml : cveTags) {
                        String cveNum = xml.getValue().orElse("");
                        for (String cve : UpdateOwaspSuppressionDate.this.cveList) {
                            if (StringUtils.isNullOrEmpty((String)cve) || !cve.equals(cveNum)) continue;
                            hasCve = true;
                            continue block0;
                        }
                    }
                    if (hasCve) {
                        String date = UpdateOwaspSuppressionDate.this.untilDate != null && !UpdateOwaspSuppressionDate.this.untilDate.isEmpty() ? UpdateOwaspSuppressionDate.this.untilDate : LocalDate.now().plusDays(30L).toString();
                        String zuluDate = date + "Z";
                        t = ((Xml.Tag)t).withAttributes(ListUtils.map(((Xml.Tag)t).getAttributes(), attr -> {
                            if ("until".equals(attr.getKeyAsString()) && !zuluDate.equals(attr.getValueAsString())) {
                                attr = attr.withValue(attr.getValue().withValue(zuluDate));
                            }
                            return attr;
                        }));
                    }
                }
                return t;
            }
        });
    }

    @Generated
    public UpdateOwaspSuppressionDate(List<String> cveList, @Nullable String untilDate) {
        this.cveList = cveList;
        this.untilDate = untilDate;
    }

    @Generated
    public List<String> getCveList() {
        return this.cveList;
    }

    @Generated
    public @Nullable String getUntilDate() {
        return this.untilDate;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpdateOwaspSuppressionDate(cveList=" + this.getCveList() + ", untilDate=" + this.getUntilDate() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateOwaspSuppressionDate)) {
            return false;
        }
        UpdateOwaspSuppressionDate other = (UpdateOwaspSuppressionDate)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<String> this$cveList = this.getCveList();
        List<String> other$cveList = other.getCveList();
        if (this$cveList == null ? other$cveList != null : !((Object)this$cveList).equals(other$cveList)) {
            return false;
        }
        String this$untilDate = this.getUntilDate();
        String other$untilDate = other.getUntilDate();
        return !(this$untilDate == null ? other$untilDate != null : !this$untilDate.equals(other$untilDate));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpdateOwaspSuppressionDate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $cveList = this.getCveList();
        result = result * 59 + ($cveList == null ? 43 : ((Object)$cveList).hashCode());
        String $untilDate = this.getUntilDate();
        result = result * 59 + ($untilDate == null ? 43 : $untilDate.hashCode());
        return result;
    }
}

