/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.search;

import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.xml.trait.Namespaced;
import org.openrewrite.xml.tree.Xml;

public final class HasNamespaceUri
extends Recipe {
    @Option(displayName="Namespace URI", description="The Namespace URI to find.", example="http://www.w3.org/2001/XMLSchema-instance")
    private final String namespaceUri;
    @Option(displayName="XPath", description="An XPath expression used to find namespace URIs.", example="/dependencies/dependency", required=false)
    @Nullable
    private final String xPath;

    public String getDisplayName() {
        return "Find XML namespace URIs";
    }

    public String getDescription() {
        return "Find XML namespace URIs, optionally restricting the search by a XPath expression.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Namespaced.matcher().xPath(this.xPath).uri(this.namespaceUri).asVisitor(n -> n.getTree() instanceof Xml.Tag ? SearchResult.found((Tree)((Xml)n.getTree())) : n.getTree());
    }

    public static Set<Xml.Tag> find(Xml x, String namespaceUri, @Nullable String xPath) {
        LinkedHashSet<Xml.Tag> ts = new LinkedHashSet<Xml.Tag>();
        Namespaced.matcher().xPath(xPath).uri(namespaceUri).asVisitor(n -> {
            if (n.getTree() instanceof Xml.Tag) {
                ts.add((Xml.Tag)n.getTree());
            }
            return n.getTree();
        }).visit((Tree)x, (Object)0);
        return ts;
    }

    @Generated
    public HasNamespaceUri(String namespaceUri, @Nullable String xPath) {
        this.namespaceUri = namespaceUri;
        this.xPath = xPath;
    }

    @Generated
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Nullable
    @Generated
    public String getXPath() {
        return this.xPath;
    }

    @NonNull
    @Generated
    public String toString() {
        return "HasNamespaceUri(namespaceUri=" + this.getNamespaceUri() + ", xPath=" + this.getXPath() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasNamespaceUri)) {
            return false;
        }
        HasNamespaceUri other = (HasNamespaceUri)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$namespaceUri = this.getNamespaceUri();
        String other$namespaceUri = other.getNamespaceUri();
        if (this$namespaceUri == null ? other$namespaceUri != null : !this$namespaceUri.equals(other$namespaceUri)) {
            return false;
        }
        String this$xPath = this.getXPath();
        String other$xPath = other.getXPath();
        return !(this$xPath == null ? other$xPath != null : !this$xPath.equals(other$xPath));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof HasNamespaceUri;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespaceUri = this.getNamespaceUri();
        result = result * 59 + ($namespaceUri == null ? 43 : $namespaceUri.hashCode());
        String $xPath = this.getXPath();
        result = result * 59 + ($xPath == null ? 43 : $xPath.hashCode());
        return result;
    }
}

