/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.security;

import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.security.IsOwaspSuppressionsFile;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class RemoveOwaspSuppressions
extends Recipe {
    public String getDisplayName() {
        return "Remove out-of-date OWASP suppressions";
    }

    public String getDescription() {
        return "Remove all OWASP suppressions with a suppression end date in the past, as these are no longer valid. For use with the OWASP `dependency-check` tool. More details on OWASP suppression files can be found [here](https://jeremylong.github.io/DependencyCheck/general/suppression.html).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsOwaspSuppressionsFile(), (TreeVisitor)new XmlIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml t = super.visitTag(tag, ctx);
                if (!new XPathMatcher("/suppressions").matches(this.getCursor()) || ((Xml.Tag)t).getContent() == null) {
                    return t;
                }
                return ((Xml.Tag)t).withContent(ListUtils.map(((Xml.Tag)t).getContent(), c -> this.isPastDueSuppression((Content)c) ? null : c));
            }

            private boolean isPastDueSuppression(Content content) {
                Xml.Tag child;
                if (content instanceof Xml.Tag && (child = (Xml.Tag)content).getName().equals("suppress")) {
                    for (Xml.Attribute attribute : child.getAttributes()) {
                        if (!attribute.getKeyAsString().equals("until")) continue;
                        String maybeDate = attribute.getValueAsString();
                        if (maybeDate.endsWith("Z")) {
                            maybeDate = maybeDate.substring(0, maybeDate.length() - 1);
                        }
                        try {
                            LocalDate date = LocalDate.parse(maybeDate);
                            if (!date.isBefore(LocalDate.now().minusDays(1L))) continue;
                            return true;
                        }
                        catch (DateTimeParseException e) {
                            return false;
                        }
                    }
                }
                return false;
            }
        });
    }

    @NonNull
    public String toString() {
        return "RemoveOwaspSuppressions()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveOwaspSuppressions)) {
            return false;
        }
        RemoveOwaspSuppressions other = (RemoveOwaspSuppressions)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveOwaspSuppressions;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

