/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class FindTags
extends Recipe {
    @Option(displayName="XPath", description="An XPath expression used to find matching tags.", example="//dependencies/dependency")
    private final String xpath;

    public String getDisplayName() {
        return "Find XML tags";
    }

    public String getDescription() {
        return "Find XML tags by XPath expression.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final XPathMatcher matcher = new XPathMatcher(this.xpath);
        return new XmlVisitor<ExecutionContext>(){

            @Override
            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, ctx);
                if (matcher.matches(this.getCursor())) {
                    t = (Xml.Tag)SearchResult.found((Tree)t);
                }
                return t;
            }
        };
    }

    public static Set<Xml.Tag> find(Xml x, String xPath) {
        final XPathMatcher matcher = new XPathMatcher(xPath);
        HashSet<Xml.Tag> ts = new HashSet<Xml.Tag>();
        new XmlVisitor<Set<Xml.Tag>>(){

            @Override
            public Xml visitTag(Xml.Tag tag, Set<Xml.Tag> ts) {
                if (matcher.matches(this.getCursor())) {
                    ts.add(tag);
                }
                return super.visitTag(tag, ts);
            }
        }.visit(x, ts);
        return ts;
    }

    @Nullable
    @Incubating(since="7.33.0")
    public static Xml.Tag findSingle(Xml x, String xPath) {
        Set<Xml.Tag> tags = FindTags.find(x, xPath);
        if (tags.size() != 1) {
            return null;
        }
        Iterator<Xml.Tag> iterator = tags.iterator();
        if (iterator.hasNext()) {
            Xml.Tag tag = iterator.next();
            return tag;
        }
        return null;
    }

    public FindTags(String xpath) {
        this.xpath = xpath;
    }

    public String getXpath() {
        return this.xpath;
    }

    @NonNull
    public String toString() {
        return "FindTags(xpath=" + this.getXpath() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTags)) {
            return false;
        }
        FindTags other = (FindTags)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$xpath = this.getXpath();
        String other$xpath = other.getXpath();
        return !(this$xpath == null ? other$xpath != null : !this$xpath.equals(other$xpath));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindTags;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xpath = this.getXpath();
        result = result * 59 + ($xpath == null ? 43 : $xpath.hashCode());
        return result;
    }
}

