/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.style.TabsAndIndentsStyle;
import org.openrewrite.xml.tree.Xml;

public class Autodetect
extends NamedStyles {
    @JsonCreator
    public Autodetect(UUID id, Collection<Style> styles) {
        super(id, "org.openrewrite.xml.Autodetect", "Auto-detected", "Automatically detect styles from a repository's existing code.", Collections.emptySet(), styles);
    }

    public static Detector detect(Stream<? extends SourceFile> sourceFiles) {
        return new Detector(sourceFiles);
    }

    public static class Detector
    implements Stream<SourceFile> {
        private final Stream<SourceFile> sourceFiles;
        private final IndentStatistics indentStatistics = new IndentStatistics();
        private final GeneralFormatStatistics generalFormatStatistics = new GeneralFormatStatistics();

        public Detector(Stream<? extends SourceFile> sourceFiles) {
            this.sourceFiles = sourceFiles.map(SourceFile.class::cast).filter((? super T xml) -> {
                if (xml instanceof Xml.Document) {
                    new FindIndentXmlVisitor().visit((Tree)xml, this.indentStatistics);
                    new FindLineFormatJavaVisitor().visit((Tree)xml, this.generalFormatStatistics);
                }
                return true;
            });
        }

        public Autodetect build() {
            try {
                this.sourceFiles.count();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return new Autodetect(Tree.randomId(), Arrays.asList(this.indentStatistics.getTabsAndIndentsStyle(), this.generalFormatStatistics.getFormatStyle()));
        }

        @Override
        public Stream<SourceFile> filter(Predicate<? super SourceFile> arg0) {
            return this.sourceFiles.filter(arg0);
        }

        @Override
        public <R> Stream<R> map(Function<? super SourceFile, ? extends R> arg0) {
            return this.sourceFiles.map(arg0);
        }

        @Override
        public IntStream mapToInt(ToIntFunction<? super SourceFile> arg0) {
            return this.sourceFiles.mapToInt(arg0);
        }

        @Override
        public LongStream mapToLong(ToLongFunction<? super SourceFile> arg0) {
            return this.sourceFiles.mapToLong(arg0);
        }

        @Override
        public DoubleStream mapToDouble(ToDoubleFunction<? super SourceFile> arg0) {
            return this.sourceFiles.mapToDouble(arg0);
        }

        @Override
        public <R> Stream<R> flatMap(Function<? super SourceFile, ? extends Stream<? extends R>> arg0) {
            return this.sourceFiles.flatMap(arg0);
        }

        @Override
        public IntStream flatMapToInt(Function<? super SourceFile, ? extends IntStream> arg0) {
            return this.sourceFiles.flatMapToInt(arg0);
        }

        @Override
        public LongStream flatMapToLong(Function<? super SourceFile, ? extends LongStream> arg0) {
            return this.sourceFiles.flatMapToLong(arg0);
        }

        @Override
        public DoubleStream flatMapToDouble(Function<? super SourceFile, ? extends DoubleStream> arg0) {
            return this.sourceFiles.flatMapToDouble(arg0);
        }

        @Override
        public Stream<SourceFile> distinct() {
            return this.sourceFiles.distinct();
        }

        @Override
        public Stream<SourceFile> sorted() {
            return this.sourceFiles.sorted();
        }

        @Override
        public Stream<SourceFile> sorted(Comparator<? super SourceFile> arg0) {
            return this.sourceFiles.sorted(arg0);
        }

        @Override
        public Stream<SourceFile> peek(Consumer<? super SourceFile> arg0) {
            return this.sourceFiles.peek(arg0);
        }

        @Override
        public Stream<SourceFile> limit(long arg0) {
            return this.sourceFiles.limit(arg0);
        }

        @Override
        public Stream<SourceFile> skip(long arg0) {
            return this.sourceFiles.skip(arg0);
        }

        @Override
        public void forEach(Consumer<? super SourceFile> arg0) {
            this.sourceFiles.forEach(arg0);
        }

        @Override
        public void forEachOrdered(Consumer<? super SourceFile> arg0) {
            this.sourceFiles.forEachOrdered(arg0);
        }

        @Override
        public Object[] toArray() {
            return this.sourceFiles.toArray();
        }

        @Override
        public <A> A[] toArray(IntFunction<A[]> arg0) {
            return this.sourceFiles.toArray(arg0);
        }

        @Override
        public SourceFile reduce(SourceFile arg0, BinaryOperator<SourceFile> arg1) {
            return this.sourceFiles.reduce(arg0, arg1);
        }

        @Override
        public Optional<SourceFile> reduce(BinaryOperator<SourceFile> arg0) {
            return this.sourceFiles.reduce(arg0);
        }

        @Override
        public <U> U reduce(U arg0, BiFunction<U, ? super SourceFile, U> arg1, BinaryOperator<U> arg2) {
            return this.sourceFiles.reduce(arg0, arg1, arg2);
        }

        @Override
        public <R> R collect(Supplier<R> arg0, BiConsumer<R, ? super SourceFile> arg1, BiConsumer<R, R> arg2) {
            return this.sourceFiles.collect(arg0, arg1, arg2);
        }

        @Override
        public <R, A> R collect(Collector<? super SourceFile, A, R> arg0) {
            return this.sourceFiles.collect(arg0);
        }

        @Override
        public Optional<SourceFile> min(Comparator<? super SourceFile> arg0) {
            return this.sourceFiles.min(arg0);
        }

        @Override
        public Optional<SourceFile> max(Comparator<? super SourceFile> arg0) {
            return this.sourceFiles.max(arg0);
        }

        @Override
        public long count() {
            return this.sourceFiles.count();
        }

        @Override
        public boolean anyMatch(Predicate<? super SourceFile> arg0) {
            return this.sourceFiles.anyMatch(arg0);
        }

        @Override
        public boolean allMatch(Predicate<? super SourceFile> arg0) {
            return this.sourceFiles.allMatch(arg0);
        }

        @Override
        public boolean noneMatch(Predicate<? super SourceFile> arg0) {
            return this.sourceFiles.noneMatch(arg0);
        }

        @Override
        public Optional<SourceFile> findFirst() {
            return this.sourceFiles.findFirst();
        }

        @Override
        public Optional<SourceFile> findAny() {
            return this.sourceFiles.findAny();
        }

        @Override
        public Iterator<SourceFile> iterator() {
            return this.sourceFiles.iterator();
        }

        @Override
        public Spliterator<SourceFile> spliterator() {
            return this.sourceFiles.spliterator();
        }

        @Override
        public boolean isParallel() {
            return this.sourceFiles.isParallel();
        }

        @Override
        public Stream<SourceFile> sequential() {
            return (Stream)this.sourceFiles.sequential();
        }

        @Override
        public Stream<SourceFile> parallel() {
            return (Stream)this.sourceFiles.parallel();
        }

        @Override
        public Stream<SourceFile> unordered() {
            return (Stream)this.sourceFiles.unordered();
        }

        @Override
        public Stream<SourceFile> onClose(Runnable arg0) {
            return (Stream)this.sourceFiles.onClose(arg0);
        }

        @Override
        public void close() {
            this.sourceFiles.close();
        }
    }

    private static class GeneralFormatStatistics {
        private int linesWithCRLFNewLines = 0;
        private int linesWithLFNewLines = 0;

        private GeneralFormatStatistics() {
        }

        public boolean isIndentedWithLFNewLines() {
            return this.linesWithLFNewLines >= this.linesWithCRLFNewLines;
        }

        public GeneralFormatStyle getFormatStyle() {
            boolean useCRLF = !this.isIndentedWithLFNewLines();
            return new GeneralFormatStyle(useCRLF);
        }
    }

    private static class FindIndentXmlVisitor
    extends XmlVisitor<IndentStatistics> {
        private FindIndentXmlVisitor() {
        }

        @Override
        public Xml visitTag(Xml.Tag tag, IndentStatistics stats) {
            this.measureFrequencies(tag.getPrefix(), stats.indentFrequencies);
            return super.visitTag(tag, stats);
        }

        @Override
        public Xml visitAttribute(Xml.Attribute attribute, IndentStatistics stats) {
            this.measureFrequencies(attribute.getPrefix(), stats.continuationIndentFrequencies);
            return super.visitAttribute(attribute, stats);
        }

        private void measureFrequencies(String prefix, IndentFrequencies frequencies) {
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            if (prefix.chars().filter(c -> {
                takeWhile.set(takeWhile.get() && (c == 10 || c == 13));
                return takeWhile.get();
            }).count() > 0L) {
                char[] chars;
                int tabIndent = 0;
                int spaceIndent = 0;
                boolean mixed = false;
                for (char c2 : chars = prefix.toCharArray()) {
                    if (c2 == '\n' || c2 == '\r') {
                        tabIndent = 0;
                        spaceIndent = 0;
                        mixed = false;
                        continue;
                    }
                    if (mixed) continue;
                    if (c2 == ' ') {
                        if (tabIndent > 0) {
                            tabIndent = 0;
                            spaceIndent = 0;
                            mixed = true;
                            continue;
                        }
                        ++spaceIndent;
                        continue;
                    }
                    if (!Character.isWhitespace(c2)) continue;
                    if (spaceIndent > 0) {
                        tabIndent = 0;
                        spaceIndent = 0;
                        mixed = true;
                        break;
                    }
                    ++tabIndent;
                }
                frequencies.spaceIndentFrequencies.merge(spaceIndent, 1L, Long::sum);
                frequencies.tabIndentFrequencies.merge(tabIndent, 1L, Long::sum);
                AtomicBoolean dropWhile = new AtomicBoolean(false);
                takeWhile.set(true);
                Map indentTypeCounts = prefix.chars().filter(c -> {
                    dropWhile.set(dropWhile.get() || c != 10 && c != 13);
                    return dropWhile.get();
                }).filter(c -> {
                    takeWhile.set(takeWhile.get() && Character.isWhitespace(c));
                    return takeWhile.get();
                }).mapToObj(c -> c == 32).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                if (indentTypeCounts.getOrDefault(true, 0L) >= indentTypeCounts.getOrDefault(false, 0L)) {
                    frequencies.linesWithSpaceIndents++;
                } else {
                    frequencies.linesWithTabIndents++;
                }
            }
        }
    }

    private static class FindLineFormatJavaVisitor
    extends XmlVisitor<GeneralFormatStatistics> {
        private FindLineFormatJavaVisitor() {
        }

        @Nullable
        public Xml visit(@Nullable Tree tree, GeneralFormatStatistics stats) {
            if (tree instanceof Xml) {
                String prefix = ((Xml)tree).getPrefix();
                char[] chars = prefix.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    char c = chars[i];
                    if (c != '\n' && c != '\r' || c != '\n') continue;
                    if (i == 0 || chars[i - 1] != '\r') {
                        stats.linesWithLFNewLines++;
                        continue;
                    }
                    stats.linesWithCRLFNewLines++;
                }
            }
            return (Xml)super.visit(tree, (Object)stats);
        }
    }

    private static class IndentFrequencies {
        private final Map<Integer, Long> spaceIndentFrequencies = new HashMap<Integer, Long>();
        private final Map<Integer, Long> tabIndentFrequencies = new HashMap<Integer, Long>();
        private int linesWithSpaceIndents = 0;
        private int linesWithTabIndents = 0;

        private IndentFrequencies() {
        }

        public boolean isIndentedWithSpaces() {
            return this.linesWithSpaceIndents >= this.linesWithTabIndents;
        }

        public boolean hasEnoughSamples() {
            return this.linesWithSpaceIndents + this.linesWithTabIndents > 1;
        }

        private TabsAndIndentsStyle getTabsAndIndentsStyle() {
            boolean useTabs = !this.isIndentedWithSpaces();
            Object i1 = null;
            Object i2 = null;
            int indent = TabsAndIndentsStyle.DEFAULT.getIndentSize();
            long indentCount = 0L;
            Map<Integer, Long> indentFrequencies = useTabs ? this.tabIndentFrequencies : this.spaceIndentFrequencies;
            for (Map.Entry<Integer, Long> current : indentFrequencies.entrySet()) {
                if (current.getKey() == 0) continue;
                long currentCount = 0L;
                for (Map.Entry<Integer, Long> candidate : indentFrequencies.entrySet()) {
                    if (candidate.getKey() == 0 || candidate.getKey() % current.getKey() != 0) continue;
                    currentCount += candidate.getValue().longValue();
                }
                if (currentCount > indentCount) {
                    indent = current.getKey();
                    indentCount = currentCount;
                    continue;
                }
                if (currentCount != indentCount) continue;
                indent = Math.min(indent, current.getKey());
            }
            return new TabsAndIndentsStyle(useTabs, useTabs ? indent : 1, useTabs ? 1 : indent, useTabs ? 2 : indent * 2);
        }
    }

    private static class IndentStatistics {
        IndentFrequencies indentFrequencies = new IndentFrequencies();
        IndentFrequencies continuationIndentFrequencies = new IndentFrequencies();

        private IndentStatistics() {
        }

        public TabsAndIndentsStyle getTabsAndIndentsStyle() {
            TabsAndIndentsStyle style = this.indentFrequencies.getTabsAndIndentsStyle();
            return this.continuationIndentFrequencies.hasEnoughSamples() ? style.withContinuationIndentSize(this.continuationIndentFrequencies.getTabsAndIndentsStyle().getIndentSize()) : style;
        }
    }
}

