/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeTagName
extends Recipe {
    @Option(displayName="Element name", description="The name of the element whose attribute's value is to be changed. Interpreted as an XPath Expression.", example="/settings/servers/server/username")
    private final String elementName;
    @Option(displayName="New name", description="The new name for the tag.", example="user")
    private final String newName;
    @Option(displayName="File matcher", description="If provided only matching files will be modified. This is a glob expression.", required=false, example="'**/application-*.xml'")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Change XML Tag Name";
    }

    public String getDescription() {
        return "Alters the name of XML tags matching the provided expression.";
    }

    public TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlIsoVisitor<ExecutionContext>(){
            private final XPathMatcher xPathMatcher;
            {
                this.xPathMatcher = new XPathMatcher(ChangeTagName.this.elementName);
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                if (this.xPathMatcher.matches(this.getCursor())) {
                    return tag.withName(ChangeTagName.this.newName);
                }
                return super.visitTag(tag, executionContext);
            }
        };
    }

    public ChangeTagName(String elementName, String newName, @Nullable String fileMatcher) {
        this.elementName = elementName;
        this.newName = newName;
        this.fileMatcher = fileMatcher;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getNewName() {
        return this.newName;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "ChangeTagName(elementName=" + this.getElementName() + ", newName=" + this.getNewName() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTagName)) {
            return false;
        }
        ChangeTagName other = (ChangeTagName)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$elementName = this.getElementName();
        String other$elementName = other.getElementName();
        if (this$elementName == null ? other$elementName != null : !this$elementName.equals(other$elementName)) {
            return false;
        }
        String this$newName = this.getNewName();
        String other$newName = other.getNewName();
        if (this$newName == null ? other$newName != null : !this$newName.equals(other$newName)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeTagName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $elementName = this.getElementName();
        result = result * 59 + ($elementName == null ? 43 : $elementName.hashCode());
        String $newName = this.getNewName();
        result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

