/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class FindTags
extends Recipe {
    @Option(displayName="XPath", description="An XPath expression used to find matching tags.", example="/dependencies/dependency")
    private final String xPath;

    public String getDisplayName() {
        return "Find XML tags";
    }

    public String getDescription() {
        return "Find XML tags by XPath expression.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final XPathMatcher matcher = new XPathMatcher(this.xPath);
        return new XmlVisitor<ExecutionContext>(){

            @Override
            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, ctx);
                if (matcher.matches(this.getCursor())) {
                    t = t.withMarkers(t.getMarkers().searchResult());
                }
                return t;
            }
        };
    }

    public static Set<Xml.Tag> find(Xml x, String xPath) {
        final XPathMatcher matcher = new XPathMatcher(xPath);
        XmlVisitor<Set<Xml.Tag>> findVisitor = new XmlVisitor<Set<Xml.Tag>>(){

            @Override
            public Xml visitTag(Xml.Tag tag, Set<Xml.Tag> ts) {
                if (matcher.matches(this.getCursor())) {
                    ts.add(tag);
                }
                return super.visitTag(tag, ts);
            }
        };
        HashSet<Xml.Tag> ts = new HashSet<Xml.Tag>();
        findVisitor.visit(x, ts);
        return ts;
    }

    public FindTags(String xPath) {
        this.xPath = xPath;
    }

    public String getXPath() {
        return this.xPath;
    }

    @NonNull
    public String toString() {
        return "FindTags(xPath=" + this.getXPath() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTags)) {
            return false;
        }
        FindTags other = (FindTags)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$xPath = this.getXPath();
        String other$xPath = other.getXPath();
        return !(this$xPath == null ? other$xPath != null : !this$xPath.equals(other$xPath));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindTags;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $xPath = this.getXPath();
        result = result * 59 + ($xPath == null ? 43 : $xPath.hashCode());
        return result;
    }
}

