/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.ArrayList;
import java.util.Comparator;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.AutoFormatVisitor;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class AddToTagVisitor<P>
extends XmlVisitor<P> {
    private final Xml.Tag scope;
    private final Xml.Tag tagToAdd;
    @Nullable
    private final Comparator<Content> tagComparator;

    public AddToTagVisitor(Xml.Tag scope, Xml.Tag tagToAdd) {
        this(scope, tagToAdd, null);
    }

    public AddToTagVisitor(Xml.Tag scope, Xml.Tag tagToAdd, @Nullable Comparator<Content> tagComparator) {
        this.scope = scope;
        this.tagToAdd = tagToAdd;
        this.tagComparator = tagComparator;
    }

    @Override
    public Xml visitTag(Xml.Tag t, P p) {
        if (this.scope.isScope(t)) {
            Xml.Tag formattedTagToAdd;
            boolean formatParent = false;
            assert (this.getCursor().getParent() != null);
            if (t.getClosing() == null) {
                t = t.withClosing(new Xml.Tag.Closing(Tree.randomId(), "\n", Markers.EMPTY, t.getName(), "")).withBeforeTagDelimiterPrefix("");
                formatParent = true;
            }
            if (!t.getClosing().getPrefix().contains("\n")) {
                t = t.withClosing(t.getClosing().withPrefix("\n"));
            }
            if (!(formattedTagToAdd = this.tagToAdd).getPrefix().contains("\n")) {
                formattedTagToAdd = formattedTagToAdd.withPrefix("\n");
            }
            ArrayList<Content> content = t.getContent() == null ? new ArrayList<Content>() : new ArrayList<Content>(t.getContent());
            content.add(formattedTagToAdd);
            if (this.tagComparator != null) {
                content.sort(this.tagComparator);
            }
            t = t.withContent(content);
            t = formatParent ? (Xml.Tag)new AutoFormatVisitor(t).visit(t, p, this.getCursor().getParent()) : (Xml.Tag)new AutoFormatVisitor(formattedTagToAdd).visit(t, p, this.getCursor().getParent());
        }
        assert (t != null);
        return super.visitTag(t, p);
    }

    public static Xml.Tag addToTag(Xml.Tag parent, Xml.Tag newChild, Cursor parentCursor) {
        return AddToTagVisitor.addToTag(parent, parent, newChild, parentCursor);
    }

    public static Xml.Tag addToTag(Xml.Tag parentScope, Xml.Tag parent, Xml.Tag newChild, Cursor parentCursor) {
        return (Xml.Tag)new AddToTagVisitor(parent, newChild).visitNonNull(parentScope, null, parentCursor);
    }
}

