/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.internal.grammar.XMLParser;
import org.openrewrite.xml.internal.grammar.XMLParserBaseVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Misc;
import org.openrewrite.xml.tree.Xml;

public class XmlParserVisitor
extends XMLParserBaseVisitor<Xml> {
    private final Path path;
    private final String source;
    private int cursor = 0;

    public XmlParserVisitor(Path path, String source) {
        this.path = path;
        this.source = source;
    }

    @Override
    public Xml.Document visitDocument(XMLParser.DocumentContext ctx) {
        return this.convert(ctx, (C c, String prefix) -> new Xml.Document(Tree.randomId(), this.path, (String)prefix, Markers.EMPTY, this.visitProlog(ctx.prolog()), this.visitElement(ctx.element()), this.source.substring(this.cursor)));
    }

    @Override
    public Xml.Prolog visitProlog(XMLParser.PrologContext ctx) {
        return this.convert(ctx, (C c, String prefix) -> new Xml.Prolog(Tree.randomId(), (String)prefix, Markers.EMPTY, this.visitXmldecl(ctx.xmldecl()), ctx.misc().stream().map(arg_0 -> ((XmlParserVisitor)this).visit(arg_0)).map(Misc.class::cast).collect(Collectors.toList())));
    }

    @Override
    public Xml visitMisc(XMLParser.MiscContext ctx) {
        if (ctx.COMMENT() != null) {
            return this.convert(ctx.COMMENT(), (TerminalNode comment, String prefix) -> new Xml.Comment(Tree.randomId(), (String)prefix, Markers.EMPTY, comment.getText().substring("<!--".length(), comment.getText().length() - "-->".length())));
        }
        return (Xml)super.visitMisc(ctx);
    }

    @Override
    public Xml visitContent(XMLParser.ContentContext ctx) {
        if (ctx.CDATA() != null) {
            Xml.CharData charData = this.convert(ctx.CDATA(), (TerminalNode cdata, String prefix) -> this.charData(cdata.getText(), true));
            ++this.cursor;
            return charData;
        }
        if (ctx.chardata() != null) {
            Xml.CharData charData = this.convert(ctx.chardata(), (C chardata, String prefix) -> this.charData(chardata.getText(), false));
            ++this.cursor;
            return charData;
        }
        if (ctx.reference() != null && ctx.reference().EntityRef() != null) {
            this.cursor += ctx.reference().EntityRef().getSymbol().getStopIndex() + 1;
            return new Xml.CharData(Tree.randomId(), "", Markers.EMPTY, false, ctx.reference().EntityRef().getText(), "");
        }
        if (ctx.COMMENT() != null) {
            return this.convert(ctx.COMMENT(), (TerminalNode comment, String prefix) -> new Xml.Comment(Tree.randomId(), (String)prefix, Markers.EMPTY, comment.getText().substring("<!--".length(), comment.getText().length() - "-->".length())));
        }
        return (Xml)super.visitContent(ctx);
    }

    private Xml.CharData charData(String text, boolean cdata) {
        boolean prefixDone = false;
        StringBuilder prefix = new StringBuilder();
        StringBuilder value = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (!prefixDone) {
                if (Character.isWhitespace(text.charAt(i))) {
                    prefix.append(text.charAt(i));
                    continue;
                }
                prefixDone = true;
                value.append(text.charAt(i));
                continue;
            }
            if (Character.isWhitespace(text.charAt(i))) {
                suffix.append(text.charAt(i));
            } else {
                suffix.setLength(0);
            }
            value.append(text.charAt(i));
        }
        String valueStr = value.toString();
        valueStr = valueStr.substring(0, valueStr.length() - suffix.length());
        return new Xml.CharData(Tree.randomId(), prefix.toString(), Markers.EMPTY, cdata, cdata ? valueStr.substring("<![CDATA[".length(), text.length() - "]]>".length()) : valueStr, suffix.toString());
    }

    @Override
    public Xml.XmlDecl visitXmldecl(XMLParser.XmldeclContext ctx) {
        return this.convert(ctx, (C c, String prefix) -> {
            this.cursor = ctx.SPECIAL_OPEN_XML().getSymbol().getStopIndex() + 1;
            String name = this.convert(ctx.SPECIAL_OPEN_XML(), (TerminalNode n, String p) -> n.getText()).substring(2);
            List<Xml.Attribute> attributes = ctx.attribute().stream().map(this::visitAttribute).collect(Collectors.toList());
            return new Xml.XmlDecl(Tree.randomId(), (String)prefix, Markers.EMPTY, name, attributes, this.prefix(ctx.getStop()));
        });
    }

    @Override
    public Xml.ProcessingInstruction visitProcessinginstruction(XMLParser.ProcessinginstructionContext ctx) {
        return this.convert(ctx, (C c, String prefix) -> {
            String name = this.convert(ctx.SPECIAL_OPEN(), (TerminalNode n, String p) -> n.getText()).substring(2);
            Xml.CharData piText = this.convert(c.PI_TEXT(), (TerminalNode cdata, String p) -> this.charData(cdata.getText(), false));
            return new Xml.ProcessingInstruction(Tree.randomId(), (String)prefix, Markers.EMPTY, name, piText, this.prefix(ctx.getStop()));
        });
    }

    @Override
    public Xml.Tag visitElement(XMLParser.ElementContext ctx) {
        return this.convert(ctx, (C c, String prefix) -> {
            String beforeTagDelimiterPrefix;
            String name = this.convert(ctx.Name(0), (TerminalNode n, String p) -> n.getText());
            List<Xml.Attribute> attributes = ctx.attribute().stream().map(this::visitAttribute).collect(Collectors.toList());
            List content = null;
            Xml.Tag.Closing closeTag = null;
            if (ctx.SLASH_CLOSE() != null) {
                beforeTagDelimiterPrefix = this.prefix(ctx.SLASH_CLOSE());
                this.cursor = ctx.SLASH_CLOSE().getSymbol().getStopIndex() + 1;
            } else {
                beforeTagDelimiterPrefix = this.prefix(ctx.CLOSE(0));
                this.cursor = ctx.CLOSE(0).getSymbol().getStopIndex() + 1;
                content = ctx.content().stream().map(arg_0 -> ((XmlParserVisitor)this).visit(arg_0)).map(Content.class::cast).collect(Collectors.toList());
                String closeTagPrefix = this.prefix(ctx.OPEN(1));
                this.cursor += 2;
                closeTag = new Xml.Tag.Closing(Tree.randomId(), closeTagPrefix, Markers.EMPTY, this.convert(ctx.Name(1), (TerminalNode n, String p) -> n.getText()), this.prefix(ctx.CLOSE(1)));
                ++this.cursor;
            }
            return new Xml.Tag(Tree.randomId(), (String)prefix, Markers.EMPTY, name, attributes, content, closeTag, beforeTagDelimiterPrefix);
        });
    }

    @Override
    public Xml.Attribute visitAttribute(XMLParser.AttributeContext ctx) {
        return this.convert(ctx, (C c, String prefix) -> {
            Xml.Ident key = this.convert(c.Name(), (TerminalNode t, String p) -> new Xml.Ident(Tree.randomId(), (String)p, Markers.EMPTY, t.getText()));
            String beforeEquals = this.convert(c.EQUALS(), (TerminalNode e, String p) -> p);
            Xml.Attribute.Value value = this.convert(c.STRING(), (TerminalNode v, String p) -> new Xml.Attribute.Value(Tree.randomId(), (String)p, Markers.EMPTY, v.getText().startsWith("'") ? Xml.Attribute.Value.Quote.Single : Xml.Attribute.Value.Quote.Double, v.getText().substring(1, c.STRING().getText().length() - 1)));
            return new Xml.Attribute(Tree.randomId(), (String)prefix, Markers.EMPTY, key, beforeEquals, value);
        });
    }

    @Override
    public Xml.DocTypeDecl visitDoctypedecl(XMLParser.DoctypedeclContext ctx) {
        return this.convert(ctx, (C c, String prefix) -> {
            this.skip(c.DOCTYPE());
            Xml.Ident name = this.convert(c.Name(), (TerminalNode n, String p) -> new Xml.Ident(Tree.randomId(), (String)p, Markers.EMPTY, n.getText()));
            Xml.Ident externalId = null;
            List<Xml.Ident> internalSubset = null;
            if (!c.externalid().getStart().equals(c.DTD_CLOSE().getSymbol())) {
                if (c.externalid().Name() != null) {
                    externalId = this.convert(c.externalid(), (C n, String p) -> new Xml.Ident(Tree.randomId(), (String)p, Markers.EMPTY, n.Name().getText()));
                }
                internalSubset = c.STRING().stream().map(s -> this.convert((TerminalNode)s, (TerminalNode attr, String p) -> new Xml.Ident(Tree.randomId(), (String)p, Markers.EMPTY, attr.getText()))).collect(Collectors.toList());
            }
            Xml.DocTypeDecl.ExternalSubsets externalSubsets = null;
            if (c.intsubset() != null) {
                String subsetPrefix = this.prefix(c.DTD_SUBSET_OPEN());
                this.cursor = c.DTD_SUBSET_OPEN().getSymbol().getStopIndex() + 1;
                ArrayList<Xml.Element> elements = new ArrayList<Xml.Element>();
                List children = c.intsubset().children;
                for (int i = 0; i < children.size(); ++i) {
                    ParserRuleContext element = (ParserRuleContext)children.get(i);
                    Xml.Ident ident = this.convert(element, (C n, String p) -> new Xml.Ident(Tree.randomId(), (String)p, Markers.EMPTY, n.getText()));
                    String beforeElementTag = "";
                    if (i == children.size() - 1) {
                        beforeElementTag = this.prefix(c.DTD_SUBSET_CLOSE());
                        this.cursor = c.DTD_SUBSET_CLOSE().getSymbol().getStopIndex() + 1;
                    }
                    elements.add(new Xml.Element(Tree.randomId(), this.prefix(element), Markers.EMPTY, Collections.singletonList(ident), beforeElementTag));
                }
                externalSubsets = new Xml.DocTypeDecl.ExternalSubsets(Tree.randomId(), subsetPrefix, Markers.EMPTY, elements);
            }
            String beforeTagDelimiterPrefix = this.prefix(c.DTD_CLOSE());
            return new Xml.DocTypeDecl(Tree.randomId(), (String)prefix, Markers.EMPTY, name, externalId, internalSubset, externalSubsets, beforeTagDelimiterPrefix);
        });
    }

    private String prefix(ParserRuleContext ctx) {
        return this.prefix(ctx.getStart());
    }

    private String prefix(@Nullable TerminalNode terminalNode) {
        return terminalNode == null ? "" : this.prefix(terminalNode.getSymbol());
    }

    private String prefix(Token token) {
        int start = token.getStartIndex();
        if (start < this.cursor) {
            return "";
        }
        String prefix = this.source.substring(this.cursor, start);
        this.cursor = start;
        return prefix;
    }

    @Nullable
    private <C extends ParserRuleContext, T> T convert(C ctx, BiFunction<C, String, T> conversion) {
        if (ctx == null) {
            return null;
        }
        T t = conversion.apply(ctx, this.prefix(ctx));
        if (ctx.getStop() != null) {
            this.cursor = ctx.getStop().getStopIndex() + (Character.isWhitespace(this.source.charAt(ctx.getStop().getStopIndex())) ? 0 : 1);
        }
        return t;
    }

    private <T> T convert(TerminalNode node, BiFunction<TerminalNode, String, T> conversion) {
        T t = conversion.apply(node, this.prefix(node));
        this.cursor = node.getSymbol().getStopIndex() + 1;
        return t;
    }

    private void skip(TerminalNode node) {
        this.cursor = node.getSymbol().getStopIndex() + 1;
    }
}

