/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.XmlRefactorVisitor;
import org.openrewrite.xml.tree.Xml;

public class ChangeTagValue {
    private ChangeTagValue() {
    }

    public static class Scoped
    extends XmlRefactorVisitor {
        private final Xml.Tag scope;
        private final String value;

        public Scoped(Xml.Tag scope, String value) {
            this.scope = scope;
            this.value = value;
            this.setCursoringOn();
        }

        public Iterable<Tag> getTags() {
            return Tags.of((String)"value", (String)this.value);
        }

        @Override
        public Xml visitTag(Xml.Tag tag) {
            Xml.Tag t = (Xml.Tag)this.refactor(tag, x$0 -> super.visitTag((Xml.Tag)x$0));
            if (this.scope.isScope(tag)) {
                Formatting formatting = Formatting.EMPTY;
                if (t.getContent() != null && t.getContent().size() == 1 && t.getContent().get(0) instanceof Xml.CharData) {
                    Xml.CharData existingValue = (Xml.CharData)t.getContent().get(0);
                    if (existingValue.getText().equals(this.value)) {
                        return t;
                    }
                    formatting = existingValue.getFormatting();
                }
                t = t.withContent(Collections.singletonList(new Xml.CharData(Tree.randomId(), false, this.value, formatting, Markers.EMPTY)));
            }
            return t;
        }
    }
}

