/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.Metadata;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XmlSourceVisitor;
import org.openrewrite.xml.internal.PrintXml;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Misc;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface Xml
extends Serializable,
Tree {
    default public String print() {
        return (String)new PrintXml().visit(this);
    }

    default public <R> R accept(SourceVisitor<R> v) {
        return (R)(v instanceof XmlSourceVisitor ? this.acceptXml((XmlSourceVisitor)v) : v.defaultTo(null));
    }

    default public <R> R acceptXml(XmlSourceVisitor<R> v) {
        return (R)v.defaultTo(null);
    }

    public static class Ident
    implements Xml {
        private final UUID id;
        private final String name;
        private final Formatting formatting;

        @Override
        public <R> R acceptXml(XmlSourceVisitor<R> v) {
            return v.visitIdent(this);
        }

        public String toString() {
            return "Ident{" + this.name + "}";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ident)) {
                return false;
            }
            Ident other = (Ident)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Ident;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "name", "formatting"})
        public Ident(UUID id, String name, Formatting formatting) {
            this.id = id;
            this.name = name;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Ident withName(String name) {
            return this.name == name ? this : new Ident(this.id, name, this.formatting);
        }

        public Ident withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Ident(this.id, this.name, formatting);
        }
    }

    public static class Element
    implements Xml {
        private final UUID id;
        private final List<Ident> subset;
        private final String beforeTagDelimiterPrefix;
        private final Formatting formatting;

        @Override
        public <R> R acceptXml(XmlSourceVisitor<R> v) {
            return v.visitElement(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Element)) {
                return false;
            }
            Element other = (Element)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Element;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "subset", "beforeTagDelimiterPrefix", "formatting"})
        public Element(UUID id, List<Ident> subset, String beforeTagDelimiterPrefix, Formatting formatting) {
            this.id = id;
            this.subset = subset;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public List<Ident> getSubset() {
            return this.subset;
        }

        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Xml.Element(id=" + this.getId() + ", subset=" + this.getSubset() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ", formatting=" + this.getFormatting() + ")";
        }

        public Element withSubset(List<Ident> subset) {
            return this.subset == subset ? this : new Element(this.id, subset, this.beforeTagDelimiterPrefix, this.formatting);
        }

        public Element withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new Element(this.id, this.subset, beforeTagDelimiterPrefix, this.formatting);
        }

        public Element withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Element(this.id, this.subset, this.beforeTagDelimiterPrefix, formatting);
        }
    }

    public static class DocTypeDecl
    implements Xml,
    Misc {
        private final UUID id;
        private final Ident name;
        private final Ident externalId;
        private final List<Ident> internalSubset;
        @Nullable
        private final ExternalSubsets externalSubsets;
        private final String beforeTagDelimiterPrefix;
        private final Formatting formatting;

        @Override
        public <R> R acceptXml(XmlSourceVisitor<R> v) {
            return v.visitDocTypeDecl(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocTypeDecl)) {
                return false;
            }
            DocTypeDecl other = (DocTypeDecl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DocTypeDecl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "name", "externalId", "internalSubset", "externalSubsets", "beforeTagDelimiterPrefix", "formatting"})
        public DocTypeDecl(UUID id, Ident name, Ident externalId, List<Ident> internalSubset, ExternalSubsets externalSubsets, String beforeTagDelimiterPrefix, Formatting formatting) {
            this.id = id;
            this.name = name;
            this.externalId = externalId;
            this.internalSubset = internalSubset;
            this.externalSubsets = externalSubsets;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Ident getName() {
            return this.name;
        }

        public Ident getExternalId() {
            return this.externalId;
        }

        public List<Ident> getInternalSubset() {
            return this.internalSubset;
        }

        public ExternalSubsets getExternalSubsets() {
            return this.externalSubsets;
        }

        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Xml.DocTypeDecl(id=" + this.getId() + ", name=" + this.getName() + ", externalId=" + this.getExternalId() + ", internalSubset=" + this.getInternalSubset() + ", externalSubsets=" + this.getExternalSubsets() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ", formatting=" + this.getFormatting() + ")";
        }

        public DocTypeDecl withName(Ident name) {
            return this.name == name ? this : new DocTypeDecl(this.id, name, this.externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix, this.formatting);
        }

        public DocTypeDecl withExternalId(Ident externalId) {
            return this.externalId == externalId ? this : new DocTypeDecl(this.id, this.name, externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix, this.formatting);
        }

        public DocTypeDecl withInternalSubset(List<Ident> internalSubset) {
            return this.internalSubset == internalSubset ? this : new DocTypeDecl(this.id, this.name, this.externalId, internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix, this.formatting);
        }

        public DocTypeDecl withExternalSubsets(ExternalSubsets externalSubsets) {
            return this.externalSubsets == externalSubsets ? this : new DocTypeDecl(this.id, this.name, this.externalId, this.internalSubset, externalSubsets, this.beforeTagDelimiterPrefix, this.formatting);
        }

        public DocTypeDecl withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new DocTypeDecl(this.id, this.name, this.externalId, this.internalSubset, this.externalSubsets, beforeTagDelimiterPrefix, this.formatting);
        }

        public DocTypeDecl withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new DocTypeDecl(this.id, this.name, this.externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix, formatting);
        }

        public static class ExternalSubsets
        implements Xml {
            private final UUID id;
            private final List<Element> elements;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ExternalSubsets)) {
                    return false;
                }
                ExternalSubsets other = (ExternalSubsets)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ExternalSubsets;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "elements", "formatting"})
            public ExternalSubsets(UUID id, List<Element> elements, Formatting formatting) {
                this.id = id;
                this.elements = elements;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public List<Element> getElements() {
                return this.elements;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "Xml.DocTypeDecl.ExternalSubsets(id=" + this.getId() + ", elements=" + this.getElements() + ", formatting=" + this.getFormatting() + ")";
            }

            public ExternalSubsets withElements(List<Element> elements) {
                return this.elements == elements ? this : new ExternalSubsets(this.id, elements, this.formatting);
            }

            public ExternalSubsets withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new ExternalSubsets(this.id, this.elements, formatting);
            }
        }
    }

    public static class Comment
    implements Xml,
    Content,
    Misc {
        private final UUID id;
        private final String text;
        private final Formatting formatting;

        @Override
        public <R> R acceptXml(XmlSourceVisitor<R> v) {
            return v.visitComment(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Comment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "text", "formatting"})
        public Comment(UUID id, String text, Formatting formatting) {
            this.id = id;
            this.text = text;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Xml.Comment(id=" + this.getId() + ", text=" + this.getText() + ", formatting=" + this.getFormatting() + ")";
        }

        public Comment withText(String text) {
            return this.text == text ? this : new Comment(this.id, text, this.formatting);
        }

        public Comment withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Comment(this.id, this.text, formatting);
        }
    }

    public static class CharData
    implements Xml,
    Content {
        private final UUID id;
        private final boolean cdata;
        private final String text;
        private final Formatting formatting;

        @Override
        public <R> R acceptXml(XmlSourceVisitor<R> v) {
            return v.visitCharData(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CharData)) {
                return false;
            }
            CharData other = (CharData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CharData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "cdata", "text", "formatting"})
        public CharData(UUID id, boolean cdata, String text, Formatting formatting) {
            this.id = id;
            this.cdata = cdata;
            this.text = text;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public boolean isCdata() {
            return this.cdata;
        }

        public String getText() {
            return this.text;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Xml.CharData(id=" + this.getId() + ", cdata=" + this.isCdata() + ", text=" + this.getText() + ", formatting=" + this.getFormatting() + ")";
        }

        public CharData withCdata(boolean cdata) {
            return this.cdata == cdata ? this : new CharData(this.id, cdata, this.text, this.formatting);
        }

        public CharData withText(String text) {
            return this.text == text ? this : new CharData(this.id, this.cdata, text, this.formatting);
        }

        public CharData withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new CharData(this.id, this.cdata, this.text, formatting);
        }
    }

    public static class Attribute
    implements Xml {
        private final UUID id;
        private final Ident key;
        private final Value value;
        private final Formatting formatting;

        @Override
        public <R> R acceptXml(XmlSourceVisitor<R> v) {
            return v.visitAttribute(this);
        }

        @JsonIgnore
        public String getKeyAsString() {
            return this.key.getName();
        }

        @JsonIgnore
        public String getValueAsString() {
            return this.value.getValue();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Attribute;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "key", "value", "formatting"})
        public Attribute(UUID id, Ident key, Value value, Formatting formatting) {
            this.id = id;
            this.key = key;
            this.value = value;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Ident getKey() {
            return this.key;
        }

        public Value getValue() {
            return this.value;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Xml.Attribute(id=" + this.getId() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", formatting=" + this.getFormatting() + ")";
        }

        public Attribute withKey(Ident key) {
            return this.key == key ? this : new Attribute(this.id, key, this.value, this.formatting);
        }

        public Attribute withValue(Value value) {
            return this.value == value ? this : new Attribute(this.id, this.key, value, this.formatting);
        }

        public Attribute withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Attribute(this.id, this.key, this.value, formatting);
        }

        public static class Value
        implements Xml {
            private final UUID id;
            private final Quote quote;
            private final String value;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Value)) {
                    return false;
                }
                Value other = (Value)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Value;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "quote", "value", "formatting"})
            public Value(UUID id, Quote quote, String value, Formatting formatting) {
                this.id = id;
                this.quote = quote;
                this.value = value;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Quote getQuote() {
                return this.quote;
            }

            public String getValue() {
                return this.value;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "Xml.Attribute.Value(id=" + this.getId() + ", quote=" + (Object)((Object)this.getQuote()) + ", value=" + this.getValue() + ", formatting=" + this.getFormatting() + ")";
            }

            public Value withQuote(Quote quote) {
                return this.quote == quote ? this : new Value(this.id, quote, this.value, this.formatting);
            }

            public Value withValue(String value) {
                return this.value == value ? this : new Value(this.id, this.quote, value, this.formatting);
            }

            public Value withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Value(this.id, this.quote, this.value, formatting);
            }

            public static enum Quote {
                Double,
                Single;

            }
        }
    }

    public static class Tag
    implements Xml,
    Content {
        private final UUID id;
        private final String name;
        private final List<Attribute> attributes;
        private final List<? extends Content> content;
        @Nullable
        private final Closing closing;
        private final String beforeTagDelimiterPrefix;
        private final Formatting formatting;

        public Tag withName(String name) {
            return new Tag(this.id, name, this.attributes, this.content, this.closing == null ? null : this.closing.withName(name), this.beforeTagDelimiterPrefix, this.formatting);
        }

        public Tag withValue(String value) {
            CharData charData = (CharData)this.content.get(0);
            return this.withContent(Collections.singletonList(charData.withText(value)));
        }

        @JsonIgnore
        public Optional<Tag> getChild(String name) {
            return this.content.stream().filter(t -> t instanceof Tag).map(Tag.class::cast).filter(t -> t.getName().equals(name)).findAny();
        }

        @JsonIgnore
        public List<Tag> getChildren(String name) {
            return this.content.stream().filter(t -> t instanceof Tag).map(Tag.class::cast).filter(t -> t.getName().equals(name)).collect(Collectors.toList());
        }

        @JsonIgnore
        public List<Tag> getChildren() {
            return this.content.stream().filter(t -> t instanceof Tag).map(Tag.class::cast).collect(Collectors.toList());
        }

        public Tag withChildValue(String childName, String text) {
            return this.getChild(childName).map(tag -> this.withContent(this.getContent().stream().map(content -> content == tag ? ((Tag)content).withValue(text) : content).collect(Collectors.toList()))).orElse(this);
        }

        @JsonIgnore
        public Optional<String> getValue() {
            if (this.content.size() != 1) {
                return Optional.empty();
            }
            if (this.content.get(0) instanceof CharData) {
                return Optional.ofNullable(((CharData)this.content.get(0)).getText());
            }
            return Optional.empty();
        }

        @JsonIgnore
        public Optional<String> getChildValue(String name) {
            return this.getChild(name).flatMap(Tag::getValue);
        }

        @JsonIgnore
        public Optional<Tag> getSibling(String name, Cursor cursor) {
            Tag parent = (Tag)cursor.getParentOrThrow().getTree();
            if (parent == null) {
                return Optional.empty();
            }
            return parent.getChild(name);
        }

        public Tag withContent(List<? extends Content> content) {
            if (this.content == content) {
                return this;
            }
            Tag tag = new Tag(this.id, this.name, this.attributes, content, this.closing, this.beforeTagDelimiterPrefix, this.formatting);
            if (this.closing == null && content != null && !content.isEmpty()) {
                Formatting indentedClosingTagFormatting = this.formatting.withPrefix(this.formatting.getPrefix().substring(Math.max(0, this.formatting.getPrefix().lastIndexOf(10))));
                if (content.get(0) instanceof CharData) {
                    return tag.withClosing(new Closing(Tree.randomId(), this.name, "", content.get(0).getPrefix().contains("\n") ? indentedClosingTagFormatting : Formatting.EMPTY));
                }
                return tag.withClosing(new Closing(Tree.randomId(), this.name, "", indentedClosingTagFormatting));
            }
            return tag;
        }

        @Override
        public <R> R acceptXml(XmlSourceVisitor<R> v) {
            return v.visitTag(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tag)) {
                return false;
            }
            Tag other = (Tag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tag;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "name", "attributes", "content", "closing", "beforeTagDelimiterPrefix", "formatting"})
        public Tag(UUID id, String name, List<Attribute> attributes, List<? extends Content> content, Closing closing, String beforeTagDelimiterPrefix, Formatting formatting) {
            this.id = id;
            this.name = name;
            this.attributes = attributes;
            this.content = content;
            this.closing = closing;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public List<? extends Content> getContent() {
            return this.content;
        }

        public Closing getClosing() {
            return this.closing;
        }

        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Xml.Tag(id=" + this.getId() + ", name=" + this.getName() + ", attributes=" + this.getAttributes() + ", content=" + this.getContent() + ", closing=" + this.getClosing() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ", formatting=" + this.getFormatting() + ")";
        }

        public Tag withAttributes(List<Attribute> attributes) {
            return this.attributes == attributes ? this : new Tag(this.id, this.name, attributes, this.content, this.closing, this.beforeTagDelimiterPrefix, this.formatting);
        }

        public Tag withClosing(Closing closing) {
            return this.closing == closing ? this : new Tag(this.id, this.name, this.attributes, this.content, closing, this.beforeTagDelimiterPrefix, this.formatting);
        }

        public Tag withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new Tag(this.id, this.name, this.attributes, this.content, this.closing, beforeTagDelimiterPrefix, this.formatting);
        }

        public Tag withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Tag(this.id, this.name, this.attributes, this.content, this.closing, this.beforeTagDelimiterPrefix, formatting);
        }

        public static class Closing
        implements Xml {
            private final UUID id;
            private final String name;
            private final String beforeTagDelimiterPrefix;
            private final Formatting formatting;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Closing)) {
                    return false;
                }
                Closing other = (Closing)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Closing;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "name", "beforeTagDelimiterPrefix", "formatting"})
            public Closing(UUID id, String name, String beforeTagDelimiterPrefix, Formatting formatting) {
                this.id = id;
                this.name = name;
                this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public String getBeforeTagDelimiterPrefix() {
                return this.beforeTagDelimiterPrefix;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "Xml.Tag.Closing(id=" + this.getId() + ", name=" + this.getName() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ", formatting=" + this.getFormatting() + ")";
            }

            public Closing withName(String name) {
                return this.name == name ? this : new Closing(this.id, name, this.beforeTagDelimiterPrefix, this.formatting);
            }

            public Closing withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
                return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new Closing(this.id, this.name, beforeTagDelimiterPrefix, this.formatting);
            }

            public Closing withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Closing(this.id, this.name, this.beforeTagDelimiterPrefix, formatting);
            }
        }
    }

    public static class ProcessingInstruction
    implements Xml,
    Misc {
        private final UUID id;
        private final String name;
        private final List<Attribute> attributes;
        private final String beforeTagDelimiterPrefix;
        private final Formatting formatting;

        @Override
        public <R> R acceptXml(XmlSourceVisitor<R> v) {
            return v.visitProcessingInstruction(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessingInstruction)) {
                return false;
            }
            ProcessingInstruction other = (ProcessingInstruction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProcessingInstruction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "name", "attributes", "beforeTagDelimiterPrefix", "formatting"})
        public ProcessingInstruction(UUID id, String name, List<Attribute> attributes, String beforeTagDelimiterPrefix, Formatting formatting) {
            this.id = id;
            this.name = name;
            this.attributes = attributes;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Xml.ProcessingInstruction(id=" + this.getId() + ", name=" + this.getName() + ", attributes=" + this.getAttributes() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ", formatting=" + this.getFormatting() + ")";
        }

        public ProcessingInstruction withName(String name) {
            return this.name == name ? this : new ProcessingInstruction(this.id, name, this.attributes, this.beforeTagDelimiterPrefix, this.formatting);
        }

        public ProcessingInstruction withAttributes(List<Attribute> attributes) {
            return this.attributes == attributes ? this : new ProcessingInstruction(this.id, this.name, attributes, this.beforeTagDelimiterPrefix, this.formatting);
        }

        public ProcessingInstruction withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new ProcessingInstruction(this.id, this.name, this.attributes, beforeTagDelimiterPrefix, this.formatting);
        }

        public ProcessingInstruction withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ProcessingInstruction(this.id, this.name, this.attributes, this.beforeTagDelimiterPrefix, formatting);
        }
    }

    public static class Prolog
    implements Xml {
        private final UUID id;
        @Nullable
        private final List<ProcessingInstruction> xmlDecls;
        private final List<Misc> misc;
        private final Formatting formatting;

        @Override
        public <R> R acceptXml(XmlSourceVisitor<R> v) {
            return v.visitProlog(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prolog)) {
                return false;
            }
            Prolog other = (Prolog)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Prolog;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "xmlDecls", "misc", "formatting"})
        public Prolog(UUID id, List<ProcessingInstruction> xmlDecls, List<Misc> misc, Formatting formatting) {
            this.id = id;
            this.xmlDecls = xmlDecls;
            this.misc = misc;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public List<ProcessingInstruction> getXmlDecls() {
            return this.xmlDecls;
        }

        public List<Misc> getMisc() {
            return this.misc;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Xml.Prolog(id=" + this.getId() + ", xmlDecls=" + this.getXmlDecls() + ", misc=" + this.getMisc() + ", formatting=" + this.getFormatting() + ")";
        }

        public Prolog withXmlDecls(List<ProcessingInstruction> xmlDecls) {
            return this.xmlDecls == xmlDecls ? this : new Prolog(this.id, xmlDecls, this.misc, this.formatting);
        }

        public Prolog withMisc(List<Misc> misc) {
            return this.misc == misc ? this : new Prolog(this.id, this.xmlDecls, misc, this.formatting);
        }

        public Prolog withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Prolog(this.id, this.xmlDecls, this.misc, formatting);
        }
    }

    @JsonIgnoreProperties(value={"styles"})
    public static class Document
    implements Xml,
    SourceFile {
        private final UUID id;
        private final String sourcePath;
        private final Collection<Metadata> metadata;
        private final Prolog prolog;
        private final Tag root;
        private final Formatting formatting;

        @Override
        public <R> R acceptXml(XmlSourceVisitor<R> v) {
            return v.visitDocument(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Document)) {
                return false;
            }
            Document other = (Document)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Document;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "sourcePath", "metadata", "prolog", "root", "formatting"})
        public Document(UUID id, String sourcePath, Collection<Metadata> metadata, Prolog prolog, Tag root, Formatting formatting) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.metadata = metadata;
            this.prolog = prolog;
            this.root = root;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public Collection<Metadata> getMetadata() {
            return this.metadata;
        }

        public Prolog getProlog() {
            return this.prolog;
        }

        public Tag getRoot() {
            return this.root;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Xml.Document(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", metadata=" + this.getMetadata() + ", prolog=" + this.getProlog() + ", root=" + this.getRoot() + ", formatting=" + this.getFormatting() + ")";
        }

        public Document withMetadata(Collection<Metadata> metadata) {
            return this.metadata == metadata ? this : new Document(this.id, this.sourcePath, metadata, this.prolog, this.root, this.formatting);
        }

        public Document withProlog(Prolog prolog) {
            return this.prolog == prolog ? this : new Document(this.id, this.sourcePath, this.metadata, prolog, this.root, this.formatting);
        }

        public Document withRoot(Tag root) {
            return this.root == root ? this : new Document(this.id, this.sourcePath, this.metadata, this.prolog, root, this.formatting);
        }

        public Document withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Document(this.id, this.sourcePath, this.metadata, this.prolog, this.root, formatting);
        }
    }
}

